/**  --------------------------------------------------------------------
 *  @file  operator-id.cc
 *  @brief Operator for the ID extension. Described in RFC2971 Oct 2000.
 *  @author Erwin Hoffmann
 *  @date 22.09.2023
 *  ------------------------------------------------------------------ **/
#include <string>
#include <iostream>

#include "depot.h"
#include "iodevice.h"
#include "iofactory.h"
#include "operators.h"
#include "recursivedescent.h"
#include "session.h"
#include "globals.h"

using namespace ::std;
using namespace Binc;

//----------------------------------------------------------------------
IdOperator::IdOperator(void)
{
}

//----------------------------------------------------------------------
IdOperator::~IdOperator(void)
{
}

//----------------------------------------------------------------------
const string IdOperator::getName(void) const
{
  return "ID";
}

//----------------------------------------------------------------------
int IdOperator::getState(void) const
{
  return Session::NONAUTHENTICATED
       | Session::AUTHENTICATED
       | Session::SELECTED;
}

//----------------------------------------------------------------------
Operator::ProcessResult IdOperator::process(Depot &depot,
                                            Request &command)
{
  bincClient << "* ID (\"name\" \"Binc IMAP\""
             << " \"version\" \"" << BINC_VERSION "\")" << endl;

  return OK;
}

//----------------------------------------------------------------------
Operator::ParseResult IdOperator::parse(Request &c_in) const
{
  Session &session = Session::getInstance();

  if (c_in.getUidMode()) return REJECT;

  Operator::ParseResult res;
  if ((res = expectSPACE()) != ACCEPT && (res = expectCRLF()) != ACCEPT) {
    session.setLastError("Expected SPACE or CRLF");
    return res;
  }

  c_in.setName("ID");

  return ACCEPT;
}
