/**  --------------------------------------------------------------------
 *  @file operator-expunge.cc
 *  @brief  Implementation of the EXPUNGE command
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005 
 *  -----------------------------------------------------------------  **/
#include <string>
    
#include "depot.h"
#include "mailbox.h"
#include "operators.h"
#include "imapparser.h"
#include "recursivedescent.h"
#include "pendingupdates.h"
#include "session.h"

using namespace ::std;
using namespace Binc;

//----------------------------------------------------------------------
ExpungeOperator::ExpungeOperator(void)
{
}

//----------------------------------------------------------------------
ExpungeOperator::~ExpungeOperator(void)
{
}

//----------------------------------------------------------------------
const string ExpungeOperator::getName(void) const
{
  return "EXPUNGE";
}

//----------------------------------------------------------------------
int ExpungeOperator::getState(void) const
{
  return Session::SELECTED;
}

//----------------------------------------------------------------------
Operator::ProcessResult ExpungeOperator::process(Depot &depot,
                                                 Request &command)
{
  Mailbox *mailbox = depot.getSelected();
  mailbox->expungeMailbox();

  pendingUpdates(mailbox, PendingUpdates::EXPUNGE
    | PendingUpdates::EXISTS 
    | PendingUpdates::RECENT
    | PendingUpdates::FLAGS, true);

  return OK;
}

//----------------------------------------------------------------------
Operator::ParseResult ExpungeOperator::parse(Request &c_in) const
{
  Session &session = Session::getInstance();

  if (c_in.getUidMode())
    return REJECT;

  Operator::ParseResult res; 
 if ((res = expectCRLF()) != ACCEPT) {
    session.setLastError("Expected CRLF");
    return res;
  }

  c_in.setName("EXPUNGE");
  return ACCEPT;
}
