/** --------------------------------------------------------------------
 *  @file operator-delete.cc
 *  @briefe  Implementation of the DELETE command.
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005 
 *  -----------------------------------------------------------------  **/
#include <string>
    
#include "depot.h"
#include "mailbox.h"
#include "operators.h"
#include "imapparser.h"
#include "recursivedescent.h"
#include "session.h"
#include "convert.h"

using namespace ::std;
using namespace Binc;

//----------------------------------------------------------------------
DeleteOperator::DeleteOperator(void)
{
}

//----------------------------------------------------------------------
DeleteOperator::~DeleteOperator(void)
{
}

//----------------------------------------------------------------------
const string DeleteOperator::getName(void) const
{
  return "DELETE";
}

//----------------------------------------------------------------------
int DeleteOperator::getState(void) const
{
  return Session::AUTHENTICATED | Session::SELECTED;
}

//------------------------------------------------------------------------
Operator::ProcessResult DeleteOperator::process(Depot &depot,
                                                Request &command)
{
  if (depot.deleteMailbox(command.getMailbox()))
    return OK;
  else {
    Session &session = Session::getInstance();
    session.setLastError(depot.getLastError());
    return NO;
  }
}

//----------------------------------------------------------------------
Operator::ParseResult DeleteOperator::parse(Request &c_in) const
{
  Session &session = Session::getInstance();

  if (c_in.getUidMode()) return REJECT;

  Operator::ParseResult res;
  if ((res = expectSPACE()) != ACCEPT) {
    session.setLastError("Expected SPACE after DELETE");
    return res;
  }

  string mailbox;
  if ((res = expectMailbox(mailbox)) != ACCEPT) {
    session.setLastError("Expected mailbox after DELETE SPACE");
    return res;
  }

  if ((res = expectCRLF()) != ACCEPT) {
    session.setLastError("Expected CRLF after DELETE SPACE mailbox");
    return res;
  }
  
  session.mailboxchanges = true;
  
  c_in.setName("DELETE");
  c_in.setMailbox(mailbox);
  return ACCEPT;
}
