/** --------------------------------------------------------------------
 *  @file bincimapd-create.cc
 *  @brief Implementation of the CREATE command.
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005 
 *  -----------------------------------------------------------------  **/
#include <string>

#include "depot.h"
#include "mailbox.h"
#include "operators.h"
#include "imapparser.h"
#include "recursivedescent.h"
#include "session.h"
#include "convert.h"

using namespace ::std;
using namespace Binc;

//----------------------------------------------------------------------
CreateOperator::CreateOperator(void)
{
}

//----------------------------------------------------------------------
CreateOperator::~CreateOperator(void)
{
}

//----------------------------------------------------------------------
const string CreateOperator::getName(void) const
{
  return "CREATE";
}

//----------------------------------------------------------------------
int CreateOperator::getState(void) const
{
  return Session::AUTHENTICATED | Session::SELECTED;
}

//------------------------------------------------------------------------
Operator::ProcessResult CreateOperator::process(Depot &depot,
                                                Request &command)
{
  if (depot.createMailbox(command.getMailbox()))
    return OK;
  else {
    Session &session = Session::getInstance();
    session.setLastError(depot.getLastError());
    return NO;
  }
}

//----------------------------------------------------------------------
Operator::ParseResult CreateOperator::parse(Request &c_in) const
{
  Session &session = Session::getInstance();

  if (c_in.getUidMode()) return REJECT;

  Operator::ParseResult res;
  if ((res = expectSPACE()) != ACCEPT) {
    session.setLastError("Expected SPACE after CREATE");
    return res;
  }

  string mailbox;
  if ((res = expectMailbox(mailbox)) != ACCEPT) {
    session.setLastError("Expected mailbox after CREATE SPACE");
    return res;
  }

  if ((res = expectCRLF()) != ACCEPT) {
    session.setLastError("Expected CRLF after CREATE SPACE CRLF");
    return res;
  }

  session.mailboxchanges = true;

  c_in.setName("CREATE");
  c_in.setMailbox(mailbox);
  return ACCEPT;
}
