/**  --------------------------------------------------------------------
 *  @file  operator-close.cc
 *  @brief  Implementation of the CLOSE command.
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005
 *  -----------------------------------------------------------------  **/
#include <string>

#include "depot.h"
#include "mailbox.h"
#include "operators.h"
#include "recursivedescent.h"
#include "session.h"

using namespace ::std;
using namespace Binc;

//----------------------------------------------------------------------
CloseOperator::CloseOperator(void)
{
}

//----------------------------------------------------------------------
CloseOperator::~CloseOperator(void)
{
}

//------------------------------------------------------------------------
const string CloseOperator::getName(void) const
{
  return "CLOSE";
}

//------------------------------------------------------------------------
int CloseOperator::getState(void) const
{
  return Session::SELECTED;
}

//------------------------------------------------------------------------
Operator::ProcessResult CloseOperator::process(Depot &depot,
                                               Request &command)
{
  Mailbox *mailbox = depot.getSelected();
  mailbox->expungeMailbox();
  mailbox->closeMailbox();
  depot.resetSelected();

  Session &session = Session::getInstance();
  session.setState(Session::AUTHENTICATED);

  return OK;
}

//----------------------------------------------------------------------
Operator::ParseResult CloseOperator::parse(Request &c_in) const
{
  Session &session = Session::getInstance();

  if (c_in.getUidMode())
    return REJECT;

  Operator::ParseResult res;
  if ((res = expectCRLF()) != ACCEPT) {
    session.setLastError("Expected CRLF after CLOSE");
    return res;
  }

  c_in.setName("CLOSE");
  return ACCEPT;
}
