/** --------------------------------------------------------------------
 *  @file  operator-check.cc
 *  @author  Implementation of the CHECK command.
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005 
 *  -----------------------------------------------------------------  **/
#include <string>
    
#include "depot.h"
#include "mailbox.h"
#include "operators.h"
#include "recursivedescent.h"
#include "pendingupdates.h"
#include "session.h"

using namespace ::std;
using namespace Binc;

//----------------------------------------------------------------------
CheckOperator::CheckOperator(void)
{
}


//----------------------------------------------------------------------
CheckOperator::~CheckOperator(void)
{
}

//----------------------------------------------------------------------
const string CheckOperator::getName(void) const
{
  return "CHECK";
}

//----------------------------------------------------------------------
int CheckOperator::getState(void) const
{
  return Session::SELECTED;
}

//------------------------------------------------------------------------
Operator::ProcessResult CheckOperator::process(Depot &depot,
                                               Request &command)
{
  Mailbox *mailbox = depot.getSelected();
  if (mailbox != 0)
    pendingUpdates(mailbox, PendingUpdates::FLAGS 
                   | PendingUpdates::EXISTS
                   | PendingUpdates::RECENT, true);

  return OK;
}

//----------------------------------------------------------------------
Operator::ParseResult CheckOperator::parse(Request &c_in) const
{
  Session &session = Session::getInstance();

  if (c_in.getUidMode()) return REJECT;

  Operator::ParseResult res;
  if ((res = expectCRLF()) != ACCEPT) {
    session.setLastError("Expected CRLF after CHECK");
    return res;
  }

  c_in.setName("CHECK");
  return ACCEPT;
}

