/** --------------------------------------------------------------------
 *  @file multilogdevice.cc
 *  @brief  Implementation of the MultilogDevice class
 *  @author Andreas Aardal Hanssen
 *  @date 2003/2023
 *  ---------------------------------------------------------------  **/
#include "multilogdevice.h"
#include <string>

#include <sys/types.h>
#include <sys/select.h>
#include <sys/time.h>
#include <unistd.h>
#include <errno.h>

using namespace ::std;
using namespace ::Binc;

//------------------------------------------------------------------------
MultilogDevice::MultilogDevice(int f) : IODevice(f)
{
}

//------------------------------------------------------------------------
MultilogDevice::~MultilogDevice(void)
{
}

//------------------------------------------------------------------------
string MultilogDevice::service(void) const
{
  return "log";
}

//------------------------------------------------------------------------
bool MultilogDevice::waitForWrite(void) const
{
  fd_set writeMask;
  FD_ZERO(&writeMask);
  FD_SET(fileno(stderr), &writeMask);

  struct timeval tv;
  tv.tv_sec = getTimeout();
  tv.tv_usec = 0;

  int result = select(fileno(stderr) + 1, 0, &writeMask,
                      0, tv.tv_sec ? &tv : 0);

  return result > 0;
}

//------------------------------------------------------------------------
bool MultilogDevice::waitForRead(void) const
{
  return false;
}

//------------------------------------------------------------------------
IODevice::WriteResult MultilogDevice::write(void)
{
  for (;;) {
    ssize_t wrote = ::write(fileno(stderr), outputBuffer.str().c_str(),
                            outputBuffer.getSize());

    if (wrote == -1) {
      if (errno == EINTR) 
        continue;
      else
        return WriteError;
    }

    if ((unsigned int) wrote == outputBuffer.getSize()) {
      outputBuffer.clear();
      return WriteDone;
    }

    outputBuffer.popString(wrote);
    return WriteWait;
  }
}

//------------------------------------------------------------------------
bool MultilogDevice::fillInputBuffer(void)
{
  return false;
}
