/**  --------------------------------------------------------------------
 *  @file mime.cc
 *  @brief  Implementation of main mime parser components
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005
 *  -----------------------------------------------------------------  **/
#include "mime.h"
#include "convert.h"
#include <string>
#include <vector>
#include <map>
#include <exception>
#include <iostream>

#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <errno.h>

using namespace ::std;

//------------------------------------------------------------------------
Binc::MimeDocument::MimeDocument(void) : MimePart()
{
  allIsParsed = false;
  headerIsParsed = false;
}

//------------------------------------------------------------------------
Binc::MimeDocument::~MimeDocument(void)
{
}

//------------------------------------------------------------------------
void Binc::MimeDocument::clear(void) const
{
  members.clear();
  h.clear();
  headerIsParsed = false;
  allIsParsed = false;
}

//------------------------------------------------------------------------
void Binc::MimePart::clear(void) const
{
  members.clear();
  h.clear();
}

//------------------------------------------------------------------------
Binc::MimePart::MimePart(void)
{
  size = 0;
  messagerfc822 = false;
  multipart = false;

  nlines = 0;
  nbodylines = 0;
}

//------------------------------------------------------------------------
Binc::MimePart::~MimePart(void)
{
}

//------------------------------------------------------------------------
Binc::HeaderItem::HeaderItem(void)
{
}

//------------------------------------------------------------------------
Binc::HeaderItem::HeaderItem(const string &key, const string &value)
{
  this->key = key;
  this->value = value;
}

//------------------------------------------------------------------------
Binc::Header::Header(void)
{
}

//------------------------------------------------------------------------
Binc::Header::~Header(void)
{
}

//------------------------------------------------------------------------
bool Binc::Header::getFirstHeader(const string &key, HeaderItem &dest) const
{
  string k = key;
  lowercase(k);

  for (vector<HeaderItem>::const_iterator i = content.begin();
       i != content.end(); ++i) {
    string tmp = (*i).getKey();
    lowercase(tmp);

    if (tmp == k) {
      dest = *i;
      return true;
    }
  }
  return false;
}

//------------------------------------------------------------------------
bool Binc::Header::getAllHeaders(const string &key, vector<HeaderItem> &dest) const
{
  string k = key;
  lowercase(k);

  for (vector<HeaderItem>::const_iterator i = content.begin();
       i != content.end(); ++i) {
    string tmp = (*i).getKey();
    lowercase(tmp);
    if (tmp == k)
      dest.push_back(*i);
  }

  return (dest.size() != 0);
}

//------------------------------------------------------------------------
void Binc::Header::clear(void) const
{
  content.clear();
}

//------------------------------------------------------------------------
void Binc::Header::add(const string &key, const string &value)
{
  content.push_back(HeaderItem(key, value));
}
