/**  --------------------------------------------------------------------
 *  @file  mime-printbody.cc
 *  @brief   Implementation of main mime parser components
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005 
 *  -----------------------------------------------------------------  **/
#include "mime.h"
#include "mime-utils.h"
#include "mime-inputsource.h"

#include "convert.h"
#include "iodevice.h"
#include "iofactory.h"

#include <string>
#include <vector>
#include <map>
#include <exception>
#include <iostream>

#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <errno.h>

using namespace ::std;

//------------------------------------------------------------------------
void Binc::MimePart::printBody(int fd, IODevice &output,
                               unsigned int startoffset,
                               unsigned int length) const
{
  if (!mimeSource || mimeSource->getFileDescriptor() != fd) {
    delete mimeSource;
    mimeSource = new MimeInputSource(fd);
  }

  mimeSource->reset();
  mimeSource->seek(bodystartoffsetcrlf + startoffset);

  if (startoffset + length > bodylength)
    length = bodylength - startoffset;

  char c = '\0';
  for (unsigned int i = 0; i < length; ++i) {
    if (!mimeSource->getChar(&c))
      break;

    output << (char)c;
  }
}
