/**  --------------------------------------------------------------------
 *  @file  mime-parseonlyheader.cc
 *  @brief  Implementation of main mime parser components
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005
 *  -----------------------------------------------------------------  **/
#include "mime.h"
#include "mime-utils.h"
#include "mime-inputsource.h"
#include "convert.h"
#include <string>
#include <vector>
#include <map>
#include <exception>
#include <iostream>

#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <errno.h>

using namespace ::std;

//------------------------------------------------------------------------
void Binc::MimeDocument::parseOnlyHeader(int fd) const
{
  if (allIsParsed || headerIsParsed)
    return;

  headerIsParsed = true;

  if (!mimeSource || mimeSource->getFileDescriptor() != fd) {
    delete mimeSource;
    mimeSource = new MimeInputSource(fd);
  } else {
    mimeSource->reset();
  }


  headerstartoffsetcrlf = 0;
  headerlength = 0;
  bodystartoffsetcrlf = 0;
  bodylength = 0;
  messagerfc822 = false;
  multipart = false;

  nlines = 0;
  nbodylines = 0;

  MimePart::parseOnlyHeader("");
}

//------------------------------------------------------------------------
int Binc::MimePart::parseOnlyHeader(const string &toboundary) const
{
  string name;
  string content;
  char cqueue[4];
  memset(cqueue, 0, sizeof(cqueue));

  headerstartoffsetcrlf = mimeSource->getOffset();

  bool quit = false;
  char c = '\0';

  while (!quit) {
    // read name
    while (1) {
      if (!mimeSource->getChar(&c)) {
        quit = true;
        break;
      }

      if (c == '\n') ++nlines;
      if (c == ':') break;
      if (c == '\n') {
        for (int i = name.length() - 1; i >= 0; --i)
           mimeSource->ungetChar();

        quit = true;
        name = "";
        break;
      }

      name += c;

      if (name.length() == 2 && name.substr(0, 2) == "\r\n") {
        name = "";
        quit = true;
        break;
      }
    }

    if (name.length() == 1 && name[0] == '\r') {
      name = "";
      break;
    }

    if (quit) break;

    while (!quit) {
      if (!mimeSource->getChar(&c)) {
        quit = true;
        break;
      }

      if (c == '\n') ++nlines;

      for (int i = 0; i < 3; ++i)
        cqueue[i] = cqueue[i + 1];

      cqueue[3] = c;
      if (strncmp(cqueue, "\r\n\r\n", 4) == 0) {
        quit = true;
        break;
      }

      if (cqueue[2] == '\n') {
    // guess the mime rfc says what can not appear on the beginning
    // of a line.
       if (!isspace(cqueue[3])) {
         if (content.length() > 2)
           content.resize(content.length() - 2);

          trim(content);
          h.add(name, content);
          name = c;
          content = "";
          break;
        }
      }

      content += c;
    }
  }

  if (name != "") {
    if (content.length() > 2)
      content.resize(content.length() - 2);
    h.add(name, content);
  }

  headerlength = mimeSource->getOffset() - headerstartoffsetcrlf;

  return 1;
}
