/**  --------------------------------------------------------------------
 *  @file mime-getpart.cc
 *  @brief  Implementation of main mime parser components
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005
 *  -----------------------------------------------------------------  **/
#include "mime.h"
#include "convert.h"
#include <string>
#include <vector>
#include <map>
#include <exception>
#include <iostream>

#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <errno.h>

using namespace ::std;

//------------------------------------------------------------------------
const Binc::MimePart *Binc::MimePart::getPart(const string &findpart,
                      string genpart, FetchType fetchType) const
{
  if (findpart == genpart)
    return this;

  if (isMultipart()) {
    if (members.size() != 0) {
      vector<MimePart>::const_iterator i = members.begin();
      int part = 1;
      while (i != members.end()) {
        BincStream ss;
        ss << genpart;
        if (genpart != "")
          ss << ".";
        ss << part;

        const MimePart *m;
        if ((m = (*i).getPart(findpart, ss.str())) != 0) {
          if (fetchType == FetchHeader && m->isMessageRFC822())
            m = &m->members[0];
          return m;
        }

        ++i;
        ++part;
      }
    }
  } else if (isMessageRFC822()) {
    if (members.size() == 1) {
      const MimePart *m = members[0].getPart(findpart, genpart);
      return m;
    } else {
      return 0;
    }
  } else {
    // Singlepart
    if (genpart != "")
      genpart += ".";
    genpart += "1";

    if (findpart == genpart)
      return this;
  }

  return 0;
}
