/**  --------------------------------------------------------------------
 *  @file maildir-select.cc
 *  @brief Implementation of the Maildir class.
 *  @author Andreas Aardal Hanssen
 *  @date Andreas Aardal Hanssen
 *  -----------------------------------------------------------------  **/
#include "maildir.h"

#include <fcntl.h>
#include <unistd.h>

using namespace ::std;
using namespace Binc;

//------------------------------------------------------------------------
bool Binc::Maildir::selectMailbox(const std::string &name,
                                  const std::string &s_in)
{
  setName(name);

  if (selected) {
    closeMailbox();
    selected = false;
  }

  oldrecent = 0;
  oldexists = 0;

  mailboxchanged = false;

  setPath(s_in);

  switch (scan()) {
  case Success: 
    break;
  case TemporaryError:
    if (scan() == Success)
      break;
  case PermanentError:
    return false;
  }

  selected = true;
  return true;
}
