/**  --------------------------------------------------------------------
 *  @file maildir-scanfilesnames.cc
 *  @brief  Implementation of the Maildir class.
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005 
 *  -----------------------------------------------------------------  **/
#include "maildir.h"

#include <iostream>
#include <iomanip>

#include <dirent.h>
#include <unistd.h>
#include <errno.h>

#include "iodevice.h"
#include "iofactory.h"

using namespace ::std;

//------------------------------------------------------------------------
bool Binc::Maildir::scanFileNames(void) const
{
  string curpath = path + "/cur/";
  DIR *pdir = opendir(curpath.c_str());
  if (pdir == 0) {
    setLastError("when scanning mailbox \""
                  + path + "\": " + string(strerror(errno)));
    bincWarning << getLastError() << endl;
    return false;
  }

  index.clearFileNames();

  struct dirent *pdirent;
  while ((pdirent = readdir(pdir)) != 0) {
    if (!isdigit(pdirent->d_name[0])) continue;

    string filename = pdirent->d_name;
    string uniquename;

    string::size_type pos;
    if ((pos = filename.find(':')) == string::npos)
      uniquename = filename;
    else
      uniquename = filename.substr(0, pos);

    index.insert(uniquename, 0, pdirent->d_name);
  }

  closedir(pdir);
  return true;
}
