/**  --------------------------------------------------------------------
 *  @file maildir-expunge.cc
 *  @brief  Implementation of the Maildir class.
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005 
 *  -----------------------------------------------------------------  **/
#include <unistd.h>
#include <errno.h>

#include "iodevice.h"
#include "iofactory.h"
#include "maildir.h"
#include "maildirmessage.h"

using namespace ::std;
using namespace Binc;

//------------------------------------------------------------------------
void Maildir::expungeMailbox(void)
{
  if (readOnly) return;

  Mailbox::iterator i = begin(SequenceSet::all(), SQNR_MODE|INCLUDE_EXPUNGED);

  bool success = true;
  for (; success && i != end(); ++i) {
    MaildirMessage &message = reinterpret_cast<MaildirMessage &>(*i);

    if ((message.getStdFlags() & Message::F_DELETED) == 0)
      continue;

    message.setExpunged();

    const string &id = message.getUnique();

    // The message might be gone already
    MaildirIndexItem *item = index.find(id);
    if (!item)
      continue;

    string fpath = path + "/cur/" + item->fileName;

    while (unlink(fpath.c_str()) != 0) {
      if (errno != ENOENT) {
        bincWarning << "unable to remove " << fpath << ": "
          << strerror(errno) << endl;
        break;
      }

      if (!scanFileNames()) {
        success = false;
        break;
      }

      if ((item = index.find(id)))
        break;
      else
        fpath = path + "/cur/" + item->fileName;
    }
  }
}
