/**  --------------------------------------------------------------------
 *  @file maildir-delete.cc
 *  @brief Implementation of the Maildir class.
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005
 *  -----------------------------------------------------------------  **/
#include "maildir.h"

#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/stat.h>

#include <dirent.h>
#include <unistd.h>

using namespace ::std;
using namespace Binc;

namespace {

  bool recursiveDelete(const string &path)
  {
    DIR *mydir = opendir(path.c_str());
    if (mydir == 0)
      return false;

    struct dirent *mydirent;
    while ((mydirent = readdir(mydir)) != 0) {
      string d = mydirent->d_name;
      if (d == "." || d == "..")
        continue;

      string f = path + "/" + d;

      struct stat mystat;
      if (lstat(f.c_str(), &mystat) != 0) {
        if (errno == ENOENT)
          continue;
        return false;
      }

      if (S_ISDIR(mystat.st_mode)) {
        if (!recursiveDelete(f)) {
          closedir(mydir);
          return false;
        }
        if (rmdir(f.c_str()) != 0 && errno != ENOENT) {
          closedir(mydir);
          return false;
        }
      } else {
        if (unlink(f.c_str()) != 0 && errno != ENOENT) {
          closedir(mydir);
          return false;
        }
      }
    }

    closedir(mydir);
    return true;
  }
}

//------------------------------------------------------------------------
bool Binc::Maildir::deleteMailbox(const string &s_in)
{
  if (s_in == ".") {
    setLastError("disallowed by rule");
    return false;
  }

  if (!recursiveDelete(s_in)) {
    setLastError("error deleting Maildir - status is undefined");
    return false;
  }

  if (rmdir(s_in.c_str()) != 0) {
    setLastError("error deleting Maildir: " 
                  + string(strerror(errno))
                  + " - status is undefined");
    return false;
  }

  return true;
}
