/**  --------------------------------------------------------------------
 *  @file maildir-create.cc
 *  @brief  Implementation of the Maildir class.
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005
 *  -----------------------------------------------------------------  **/
#include "maildir.h"

#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <sys/stat.h>

using namespace ::std;
using namespace Binc;

//------------------------------------------------------------------------
bool Binc::Maildir::createMailbox(const string &s_in, mode_t mode,
          uid_t owner, gid_t group, bool root)
{
  if (s_in != "." && mkdir(s_in.c_str(), mode) == -1) {
    setLastError("unable to create " + s_in + ": " 
     + string(strerror(errno)));
    return false;
  }

  // Allow uidvalidity, which is generated from time(0), to
  // increase with one second to avoid race conditions.
  sleep(1);

  if (mkdir((s_in + "/cur").c_str(), mode) == -1) {
    setLastError("unable to create " + s_in + "/cur: " 
     + string(strerror(errno)));
    return false;
  }

  if (mkdir((s_in + "/new").c_str(), mode) == -1) {
    setLastError("unable to create " + s_in + "/new: " 
     + string(strerror(errno)));
    return false;
  }

  if (mkdir((s_in + "/tmp").c_str(), mode) == -1) {
    setLastError("unable to create " + s_in + "/tmp: " 
     + string(strerror(errno)));
    return false;
  }

  if (owner == 0 && group == 0)
    return true;

  if (chown(s_in.c_str(), owner, group) == -1) {
    setLastError("unable to chown " + s_in + ": " 
     + string(strerror(errno)));
    return false;
  }

  if (chown((s_in + "/cur").c_str(), owner, group) == -1) {
    setLastError("unable to chown " + s_in + "/cur: "
     + string(strerror(errno)));
    return false;
  }

  if (chown((s_in + "/new").c_str(), owner, group) == -1) {
    setLastError("unable to chown " + s_in + "/new: "
     + string(strerror(errno)));
    return false;
  }

  if (chown((s_in + "/tmp").c_str(), owner, group) == -1) {
    setLastError("unable to chown " + s_in + "/tmp: "
     + string(strerror(errno)));
    return false;
  }

  return true;
}
