/**  --------------------------------------------------------------------
 *  @file  maildir-close.cc
 *  @brief  Implementation of the Maildir class.
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005
 *  -----------------------------------------------------------------  **/
#include "maildir.h"

#include <fcntl.h>
#include <unistd.h>

using namespace ::std;
using namespace Binc;

//------------------------------------------------------------------------
void Binc::Maildir::closeMailbox(void)
{
  if (!selected)
    return;

  if (mailboxchanged && !readOnly)
    writeCache();

  mailboxchanged = false;

  MaildirMessageCache::getInstance().clear();

  messages.clear();
  index.clear();
  newMessages.clear();
  oldrecent = 0;
  oldexists = 0;
  firstscan = true;
  cacheRead = false;
  uidvalidity = 0;
  uidnext = 1;
  selected = false;
  path = "";

  old_bincimap_cache_st_mtime = 0; 
  old_bincimap_cache_st_ctime = 0;
  old_cur_st_mtime = 0; 
  old_cur_st_ctime = 0;
  old_new_st_mtime = 0;
  old_new_st_ctime = 0;
}
