/**  --------------------------------------------------------------------
 *  @file mailbox.cc
 *  @brief  Implementation of the Mailbox class.
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005 
 *  -----------------------------------------------------------------  **/
#include <string>

#include "mailbox.h"
#include "message.h"

using namespace ::std;
using namespace Binc;

//------------------------------------------------------------------------
Mailbox::BaseIterator::BaseIterator(int sqn)
{
  sqnr = sqn;
}

//------------------------------------------------------------------------
Mailbox::BaseIterator::~BaseIterator(void)
{
}

//------------------------------------------------------------------------
Mailbox::Mailbox(void) : readOnly(false)
{
}

//------------------------------------------------------------------------
Mailbox::~Mailbox(void)
{
}

//------------------------------------------------------------------------
bool Mailbox::isReadOnly(void) const
{
  return readOnly;
}

//------------------------------------------------------------------------
void Mailbox::setReadOnly(bool readOnly)
{
  this->readOnly = readOnly;
}

//------------------------------------------------------------------------
Mailbox::iterator::iterator(BaseIterator &i)
  : realIterator(i)
{
}

//------------------------------------------------------------------------
Message &Mailbox::iterator::operator *(void)
{
  return *realIterator;
}

//------------------------------------------------------------------------
void Mailbox::iterator::operator ++(void)
{
  ++realIterator;
}

//------------------------------------------------------------------------
bool Mailbox::iterator::operator ==(const iterator &i) const
{
  return realIterator == i.realIterator;
}

//------------------------------------------------------------------------
bool Mailbox::iterator::operator !=(const iterator &i) const
{
  return realIterator != i.realIterator;
}

//------------------------------------------------------------------------
void Mailbox::iterator::erase(void)
{
  realIterator.erase();
}

//------------------------------------------------------------------------
unsigned int Mailbox::iterator::getSqnr(void) const
{
  return realIterator.sqnr;
}

//------------------------------------------------------------------------
void Mailbox::setName(const string &name)
{
  this->name = name;
}

//------------------------------------------------------------------------
const string Mailbox::getName(void) const
{
  return name;
}

//------------------------------------------------------------------------
const string &Mailbox::getLastError(void) const
{
  return lastError;
}

//------------------------------------------------------------------------
void Mailbox::setLastError(const string &error) const
{
  lastError = error;
}
