/*  --------------------------------------------------------------------
 *  @file iofactory.cc
 *  @brief Implementation of the IOFactory class.
 *  @author Andreas Aardal Hanssen
 *  @date 2002, 2003
 *  -----------------------------------------------------------------  **/
#include "iofactory.h"
#include "iodevice.h"

using namespace ::Binc;
using namespace ::std;

//------------------------------------------------------------------------
IOFactory::IOFactory(void)
{
}

//------------------------------------------------------------------------
IOFactory::~IOFactory(void)
{
}

//------------------------------------------------------------------------
IOFactory &IOFactory::getInstance(void)
{
  static IOFactory ioFactory;
  return ioFactory;
}

//------------------------------------------------------------------------
void IOFactory::addDevice(IODevice *dev)
{
  IODevice *ioDevice = IOFactory::getInstance().devices[dev->service()];

  // FIXME: Delete correct object. Now, only IODevice's destructor is
  // called, and only IODevice's memory is freed.
  if (ioDevice)
    delete ioDevice;

  IOFactory::getInstance().devices[dev->service()] = dev;
}

//------------------------------------------------------------------------
IODevice &IOFactory::getClient(void)
{
  static IODevice nulDevice;

  IOFactory &ioFactory = IOFactory::getInstance();

  if (ioFactory.devices.find("client") != ioFactory.devices.end())
    return *ioFactory.devices["client"];

  return nulDevice;
}

//------------------------------------------------------------------------
IODevice &IOFactory::getLogger(void)
{
  static IODevice nulDevice;

  IOFactory &ioFactory = IOFactory::getInstance();

  if (ioFactory.devices.find("log") != ioFactory.devices.end())
    return *ioFactory.devices["log"];
  return nulDevice;
}
