/** --------------------------------------------------------------------
 *  @file Syslogdevice.h
 *  @brief Declaration of the SyslogDevice class.
 *  @author Andreas Aardal Hanssen
 *  @date 2002, 2003
 *  -----------------------------------------------------------------  **/
#ifndef syslogdevice_h_included
#define syslogdevice_h_included

#include "iodevice.h"
#include <syslog.h>

namespace Binc {
  class SyslogDevice : public IODevice {
  public:
    SyslogDevice(int flags, const char *ident = "bincimap", 
                 int option = LOG_NDELAY | LOG_PID, 
                 int facility = LOG_USER);
    ~SyslogDevice();

    void setPriority(int p);

    std::string service(void) const;

  protected:
    bool waitForWrite(void) const;
    bool waitForRead(void) const;

    WriteResult write(void);
    bool fillInputBuffer(void);   

  private:
    static std::string ident;

    int option;
    int facility;
    int priority;
  };
}

#endif
