/**  --------------------------------------------------------------------
 *  @file stdiodevice.h
 *  @brief Declaration of the StdIODevice class.
 *  @author Andreas Aardal Hanssen
 *  @date 2002, 2003 
 *  -----------------------------------------------------------------  **/
#ifndef stdiodevice_h_included
#define stdiodevice_h_included

#include "iodevice.h"

namespace Binc {
  class StdIODevice : public IODevice {
  public:
    StdIODevice(int flags);
    ~StdIODevice();

    std::string service(void) const;

    bool canRead(void) const;

  protected:
    bool waitForWrite(void) const;
    bool waitForRead(void) const;

    WriteResult write(void);
    bool fillInputBuffer(void);   
  };
}

#endif
