/**  --------------------------------------------------------------------
 *  @file status.h
 *  @brief  Declaration of the Status class.
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005
 *  -----------------------------------------------------------------  **/
#ifndef status_h_included
#define status_h_included

namespace Binc {

  //------------------------------------------------------------------------
  class Status {

    //--
    int recent;
    int messages;
    int unseen;
    int uidvalidity;
    int uidnext;

    //--
    int statusid;

  public:

    //--
    inline void setMessages(int i)  { messages = i; }
    inline void setRecent(int i) { recent = i; }
    inline void setStatusID(int i) { statusid = i; }
    inline void setUnseen(int i) { unseen = i; }
    inline void setUidValidity(int i) { uidvalidity = i; }
    inline void setUidNext(int i) { uidnext = i; }
    
    //--
    inline int getMessages(void) const { return messages; }
    inline int getRecent(void) const { return recent; }
    inline int getStatusID(void) const { return statusid; }
    inline int getUnseen(void) const { return unseen; }
    inline int getUidValidity(void) const { return uidvalidity; }
    inline int getUidNext(void) const { return uidnext; }


    //--
    Status(void);
    ~Status(void);
  };
}

#endif
