/**  --------------------------------------------------------------------
 *  @file recursivedescent.h
 *  @brief  Declaration of a recursive descent IMAP command parser.
 *  @author Andreas Aardal Hanssen
 *  @date Andreas Aardal Hanssen
 *  -----------------------------------------------------------------  **/
#ifndef expectcommand_h_inluded
#define expectcommand_h_inluded
#include <stack>
#include <string>

#include "imapparser.h"
#include "operators.h"

namespace Binc {

  extern std::stack<int> inputBuffer;
  extern int charnr;

  int readChar(void);
  void unReadChar(int c_in);
  void unReadChar(const std::string &s_in);

  Operator::ParseResult expectTag(std::string &s_in);
  Operator::ParseResult expectTagChar(int &c_in);
  Operator::ParseResult expectSPACE(void);

  Operator::ParseResult expectFlag(std::vector<std::string> &v_in);

  Operator::ParseResult expectListMailbox(std::string &s_in);
  Operator::ParseResult expectListWildcards(int &c_in);

  Operator::ParseResult expectDateTime(std::string &s_in);
  Operator::ParseResult expectTime(std::string &s_in);
  Operator::ParseResult expectZone(std::string &s_in);

  Operator::ParseResult expectMailbox(std::string &s_in);
  Operator::ParseResult expectAstring(std::string &s_in);
  Operator::ParseResult expectAtom(std::string &s_in);
  Operator::ParseResult expectAtomChar(int &i_in);
  Operator::ParseResult expectString(std::string &s_in);
    
  Operator::ParseResult expectDate(std::string &s_in);

  Operator::ParseResult expectNumber(unsigned int &i_in);
  Operator::ParseResult expectDigit(unsigned int &i_in);
  Operator::ParseResult expectDigitNZ(unsigned int &i_in);

  Operator::ParseResult expectLiteral(std::string &s_in);
  Operator::ParseResult expectQuoted(std::string &s_in);
  Operator::ParseResult expectQuotedChar(int &c_in);

  Operator::ParseResult expectSet(SequenceSet &s_in);
  Operator::ParseResult expectSequenceNum(unsigned int &i_in);
  Operator::ParseResult expectNZNumber(unsigned int &i_in);

  Operator::ParseResult expectCRLF(void);
  Operator::ParseResult expectCR(void);
  Operator::ParseResult expectLF(void);

  Operator::ParseResult expectThisString(const std::string &s_in);
}

#endif
