/**  --------------------------------------------------------------------
 *  @file iofactory.h
 *  @brief  Declaration of the IOFactory class.
 *  @author Andreas Aardal Hanssen
 *  @date 2002, 2003
 *  -----------------------------------------------------------------  **/
#ifndef IOFACTORY_H_INCLUDED
#define IOFACTORY_H_INCLUDED
#include <map>
#include <string>

#include "iodevice.h"

namespace Binc {
  class IOFactory {
  public:
    ~IOFactory(void);

    static void addDevice(IODevice *dev);
    static IOFactory &getInstance(void);
    static IODevice &getClient(void);
    static IODevice &getLogger(void);

  private:
    IOFactory(void);
    
    std::map<std::string, IODevice *> devices;
  };
}

#define bincClient \
  IOFactory::getClient()

#if defined (DEBUG)
//#define bincError if (false) std::cout
#define bincError std::cerr
// #define bincWarning if (false) std::cout
#define bincWarning std::cerr
#define bincDebug std::cerr
//#define bincDebug if (false) std::cout
#else
#define bincError \
  IOFactory::getLogger().setOutputLevel(IODevice::ErrorLevel);IOFactory::getLogger()
#define bincWarning \
  IOFactory::getLogger().setOutputLevel(IODevice::WarningLevel);IOFactory::getLogger()
#define bincDebug \
  IOFactory::getLogger().setOutputLevel(IODevice::DebugLevel);IOFactory::getLogger()
#endif

#define bincLog \
  IOFactory::getLogger().setOutputLevel(IODevice::InfoLevel);IOFactory::getLogger()

#endif
