/**  --------------------------------------------------------------------
 *  @file  imapserver.h
 *  @brief Declaration of the IMAPServer class.
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005
 *  -----------------------------------------------------------------  **/

namespace Binc {

  class IMAPServer {
  public:
    IMAPServer(int argc, char *argv[]);
    ~IMAPServer(void);

    int initialize(void);
    int runStub(void);
    int run(void);

    enum ServerStatus {
      OK,
      RequestError,
			RequestIgnore, // required for StartTLS, premature answer
      RequestRejected,
      ClientDisconnected,
      Timeout
    };

  private:
    void prepareForNextRequest(void);

    int argc;
    char **argv;
    bool stubMode;

    ServerStatus serverStatus;
  };
}
