/**  --------------------------------------------------------------------
 *  @file broker.h
 *  @brief Declaration of the Broker class.
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005
 *  -----------------------------------------------------------------  **/
#ifndef broker_h_included
#define broker_h_included
#include "depot.h"
#include "operators.h"

#include <string>
#include <map>

namespace Binc {

  class Request;
  class Broker;

  //------------------------------------------------------------------
  class BrokerFactory {
  private:
    std::map<int, Broker *> brokers;

    //--
    BrokerFactory(void);

    mutable std::string lastError;

  public:
    Broker *getBroker(int state);
    void assign(const std::string &fname, Operator *o);
    void addCapability(const std::string &c);
    Operator *getOperator(int state, const std::string &name) const;

    inline const std::string &getLastError(void) const;
    inline void setLastError(const std::string &error) const;

    //--
    static BrokerFactory &getInstance(void);
    ~BrokerFactory(void);
  };

  //------------------------------------------------------------------
  inline const std::string &BrokerFactory::getLastError(void) const
  {
    return lastError;
  }

  //------------------------------------------------------------------
  inline void BrokerFactory::setLastError(const std::string &error) const
  {
    lastError = error;
  }

  //------------------------------------------------------------------
  class Broker {
  private:
    std::map<std::string, Operator *> operators;
    std::map<std::string, bool> deletables;

  public:
    Operator * get(const std::string &name) const;
    void assign(const std::string &fname, Operator *o, bool deletable = false);
    Operator::ParseResult parseStub(Request &cmd);

    //--
    inline Broker(Broker &);
    inline Broker(const Broker &);
    Broker(void);
    ~Broker(void);
  };

  inline Broker::Broker(Broker &)
  {
  }

  inline Broker::Broker(const Broker &)
  {
  }

}

#endif
