/**  --------------------------------------------------------------------
 *  @file argparser.h
 *  @brief  Declaration of the argument parser class.
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005
 *  -----------------------------------------------------------------  **/
#ifndef ARGPARSER_H_INCLUDED
#define ARGPARSER_H_INCLUDED
#include <map>
#include <string>
#include <vector>

namespace Binc {
  class ArgOpts {
  public:
    std::string c;
    bool b;
    bool o;
    std::string desc;

    inline ArgOpts(const std::string &chr, bool boolean, bool optional,
                   const std::string &descr)
    {
      c = chr;
      b = boolean;
      o = optional;
      desc = descr;
    }
  };

  class CommandLineArgs {
  public:
    CommandLineArgs(void);

    bool parse(int argc, char *argv[]);
    std::string errorString(void) const;

    int argc(void) const;

    const std::string operator [](const std::string &arg) const;

    void addOptional(const std::string &arg, const std::string &desc,
                     bool boolean);
    void addRequired(const std::string &arg, const std::string &desc,
                     bool boolean);
    bool hasArg(const std::string &arg) const;

    std::string usageString(void) const;

    void setTail(const std::string &str);

    const std::vector<std::string> &getUnqualifiedArgs() const;

  private:
    void registerArg(const std::string &arg, const std::string &desc,
                     bool boolean, bool optional);

    std::string errString;
    std::map<std::string, ArgOpts> reg;
    std::map<std::string, std::string> args;
    std::map<std::string, bool> passedArgs;
    std::vector<std::string> unqualified;
    std::string tail;
    std::string head;
    int ac;
  };
}

#endif
