/**  --------------------------------------------------------------------
 *  @file greeting.cc
 *  @brief Implementation of the inital greeting.
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005
 *  -----------------------------------------------------------------  **/
#include <time.h>

#include "iodevice.h"
#include "iofactory.h"
#include "session.h"
#include "globals.h"

using namespace ::std;
using namespace Binc;

static const unsigned int ISO8601SIZE = 32;

namespace Binc {
  void showGreeting(void);
};


//------------------------------------------------------------------------
void Binc::showGreeting(void)
{
  Session &session = Session::getInstance();

  time_t t = time(0);
  struct tm *mytm = localtime(&t);

  char mytime[ISO8601SIZE];
  unsigned int size = strftime(mytime, sizeof(mytime), "%Y-%m-%d %H:%M:%S %z", mytm);
  if (size >= sizeof(mytime) || size == 0)
    mytime[0] = 0;

  if (session.hasEnv("VERBOSE_GREETING")) {
    bincClient << "* OK Welcome to Binc IMAP "
		  << BINC_VERSION 
			<< " "
		  << IMAP_VERSION 
      << " by Andreas Aardal Hanssen & Erwin Hoffmann at "
      << mytime << endl;
  } else {
    bincClient << "* OK Welcome to Binc IMAP at " << mytime << endl;
  }
}
