/**  --------------------------------------------------------------------
 *  @file convert.cc
 *  @brief Implementation of miscellaneous convertion functions
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005 
 *  -----------------------------------------------------------------  **/
#include "convert.h"
#include <string>

using namespace ::std;
using namespace Binc;

//------------------------------------------------------------------------
BincStream::BincStream(void)
{
}

//------------------------------------------------------------------------
BincStream::~BincStream(void)
{
  clear();
}

//------------------------------------------------------------------------
string BincStream::popString(unsigned int size)
{
  if (size > nstr.length())
    size = nstr.length();
  string tmp = nstr.substr(0, size);
  nstr = nstr.substr(size);
  return tmp;
}

//------------------------------------------------------------------------
char BincStream::popChar(void)
{
  if (nstr.length() == 0)
    return '\0';

  char c = nstr[0];
  nstr = nstr.substr(1);
  return c;
}

//------------------------------------------------------------------------
void BincStream::unpopChar(char c)
{
  nstr = c + nstr;
}

//------------------------------------------------------------------------
void BincStream::unpopStr(const string &s)
{
  nstr = s + nstr;
}

//------------------------------------------------------------------------
const string &BincStream::str(void) const
{
  return nstr;
}

//------------------------------------------------------------------------
void BincStream::clear(void)
{
  nstr = "";
}

//------------------------------------------------------------------------
unsigned int BincStream::getSize(void) const
{
  return (unsigned int) nstr.length();
}

//------------------------------------------------------------------------
BincStream &BincStream::operator << (std::ostream&(*)(std::ostream&))
{
  nstr += "\r\n";
  return *this;
}

//------------------------------------------------------------------------
BincStream &BincStream::operator << (const string &t)
{
  nstr += t;
  return *this;
}

//------------------------------------------------------------------------
BincStream &BincStream::operator << (int t)
{
  nstr += toString(t);
  return *this;
}

//------------------------------------------------------------------------
BincStream &BincStream::operator << (unsigned long t)
{
  nstr += toString(t);
  return *this;
}

BincStream &BincStream::operator << (unsigned int t)
{
  nstr += toString(t);
  return *this;
}

//------------------------------------------------------------------------
BincStream &BincStream::operator << (char t)
{
  nstr += t;
  return *this;
}
