/** --------------------------------------------------------------------
 *  @file bincimap-updatecache.cc
 *  @brief Implementation of the bincimap-updatecache tool.
 *  @author Andreas Aardal Hanssen
 *  @date 2002-2005
 *  -----------------------------------------------------------------  **/
#include "depot.h"
#include "mailbox.h"
#include "maildir.h"
#include "session.h"

using namespace ::Binc;
using namespace ::std;

int main(int argc, char *argv[])
{
  if (argc < 2) {
    fprintf(stderr, "usage: %s <directory> ", argv[0]);
    fprintf(stderr, "Updates the cache file in <directory>.\n");
    fprintf(stderr, "Use export $DEPOT=\"IMAPdir\" to enable updates for this type.\n");
    return 1;
  }

  Session &session = Session::getInstance();

  DepotFactory &depotfactory = DepotFactory::getInstance();
  depotfactory.assign(new IMAPdirDepot());
  depotfactory.assign(new MaildirPPDepot());

  string depottype = session.getEnv("DEPOT");
  if (depottype == "") depottype = "Maildir++";

  Depot *depot;
  if ((depot = depotfactory.get(depottype)) == 0) {
    fprintf(stderr, "Found no Depot for \"%s\". Please check " \
                     " your configurations file under the Mailbox section.\n",
                     depottype.c_str());
    return 1;
  }

  depot->assign(new Maildir());
  depot->setDefaultType("Maildir");

  Mailbox *mailbox = depot->get(depot->filenameToMailbox(argv[1]));

  if (!mailbox) {
    fprintf(stderr, "selecting mailbox failed: %s\n",
	    depot->getLastError().c_str());
    return 1;
  }

  if (!mailbox->selectMailbox(argv[1], argv[1])) {
    fprintf(stderr, "selecting mailbox failed: %s\n",
	    mailbox->getLastError().c_str());
    return 1;
  }

  mailbox->closeMailbox();

  return 0;
}
