/**  -------------------------------------------------------------------
 *  @file  address.cc
 *  @brief  Implementation of the Address class
 *  @author Andreas Aardal Hanssen
 *  @date 2005
 *  ---------------------------------------------------------------- **/
#include "address.h"
#include "convert.h"
#include <string>

using namespace ::std;
using namespace Binc;

//------------------------------------------------------------------------
Address::Address(const string &name, const string &addr)
{
  string::size_type pos = addr.find('@');
  this->name = name;
  if (pos != string::npos) {
    this->local = addr.substr(0, pos);
    this->host = addr.substr(pos + 1);
  } else this->local = addr;
}

//------------------------------------------------------------------------
Address::Address(const string &wholeaddress)
{
  string::size_type start = wholeaddress.find('<');
  string addr;
  if (start != string::npos)
    addr = wholeaddress.substr(start + 1);
  else
    addr = wholeaddress;

  trim(addr, "<>");

  if (start != string::npos)
    name = wholeaddress.substr(0, start);
  else
    name = "";
  trim(name);
  trim(name, "\"");

  start = addr.find('@');
  local = addr.substr(0, start);
  host = addr.substr(start + 1);

  trim(local);
  trim(host);
  trim(name);
}

//------------------------------------------------------------------------
string Address::toParenList(void) const
{
  string tmp = "(";
  tmp += name == "" ? "NIL" : toImapString(name);
  tmp += " NIL ";
  tmp += local == "" ? "\"\"" : toImapString(local);
  tmp += " ";
  tmp += host == "" ? "\"\"" : toImapString(host);
  tmp += ")";

  return tmp;
}
