Configuration and Installation of BincIMAP
==========================================

HOW TO INSTALL
--------------

- BincIMAP uses D.J.B's slashpackage convention
  for installing while trying to conserve the
  standard qmail installations:
  * untar the sqmail tar file under '/package'
  * Move to /package/mail/bincimap/bincimap-V.R.F
  and go on with installation
- Set up the bincimap package with the following
  step-by-step options or simple run (as 'root'):
  * package/install -- does it all

A) REQUIREMENTS 
---------------

1. Compiler & make utilities.
2. The directory /package is in place.
3. The UCSPI-SSL package to be installed.

Optional but very useful:

4. The UCSPI-TCP6 package (tcprules).
5. DJB's Daemontools installed and working.


B) PRE-COMPILATION CONFIGURATION
--------------------------------

1. No particular pre-compilation configuration is required. 
2. Some Linux OS have no alias for the 'c++' compiler 
   used in the Makefile.
3. Modify conf-cc to your needs; conf-ld is not used (yet).


C) INSTALLATION 
---------------

1. Upon configuration and verification
   to meet requirements, simply do

   package/install

2. Detail description of installation steps:

   package/compile -- compiles the sources
   package/upgrade -- potentially does the upgrade
   package/deploy -- installs the Binc IMAP binaries
   package/man -- installes the man pages


D) CONFIGURATION/SETUP/TEST
---------------------------

1.  You need to setup Binc IMAP setuid to some unprivileged 
    user by means of sslserver (or tcpserver). 
    A good choice would be to run it as user 'qmaild'.
    Also a 'log' user is recommended. Use 'qmaill' here.
2.  Assuming, having daemontools (or similar) installed 
    and envdir is available.
3.  Link or copy (recursively) ./service/bincimap* to /service.
4.  Configure the environment variables under ./env.
    If you do not have envdir, simply remove the call to it in ./run,
    figure out the environment variable you need and 
    include those as 'exported' variables in the ./run script. 
5.  Invoke the run script by hand and test it:
    Binc IMAP running on port 143: 
    $  telnet <hostip> 143
    Binc IMAP with StartTLS on port 143: 
    $ openssl s_client -starttls imap -crlf <hostip>:143
    Binc IMAPS on port 993:
    $ openssl s_client -crlf <hostip>:993
    While connected, do a 
    $ capability
    and watch the result.

E) MISCELLANEOUS
----------------

1. Binc IMAP comes with a full set of updated man-pages.
2. Binc IMAP currently supports IMAP4rev1 only; IMAPv4rev2 (RFC 9051) not yet.
3. Further documentation can be found in ./doc
4. Sample run files are provided at ./service
5. Run-time configuration is given via envdir ./env here.


Visit https://www.fehcom.de/ipnet/bincimap.html 
to access online man-pages and documentation.

Date: July, 25th 2024 (feh)
