;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: wasm-as %s -all -g -o %t.wasm
;; RUN: wasm-dis %t.wasm -all -o %t.wast
;; RUN: wasm-as %s -all -o %t.nodebug.wasm
;; RUN: wasm-dis %t.nodebug.wasm -all -o %t.nodebug.wast
;; RUN: wasm-opt %t.wast -all -o %t.text.wast -g -S
;; RUN: cat %t.wast | filecheck %s --check-prefix=CHECK-BINARY
;; RUN: cat %t.nodebug.wast | filecheck %s --check-prefix=CHECK-NODEBUG
;; RUN: cat %t.text.wast | filecheck %s --check-prefix=CHECK-TEXT

(module
  ;; CHECK-BINARY:      (type $mixed_results (func (result anyref f32 anyref f32)))

  ;; CHECK-BINARY:      (type $void (func))
  ;; CHECK-TEXT:      (type $mixed_results (func (result anyref f32 anyref f32)))

  ;; CHECK-TEXT:      (type $void (func))
  (type $void (func))

  ;; inline ref type in result
  (type $_=>_eqref (func (result eqref)))
  ;; CHECK-BINARY:      (type $i32-i32 (func (param i32) (result i32)))

  ;; CHECK-BINARY:      (type $3 (func (param (ref $i32-i32)) (result i32)))

  ;; CHECK-BINARY:      (type $4 (func (param (ref null $i32-i32)) (result i32)))

  ;; CHECK-BINARY:      (type $5 (func (result i32)))

  ;; CHECK-BINARY:      (type $=>eqref (func (result eqref)))

  ;; CHECK-BINARY:      (type $f64_=>_ref_null<_->_eqref> (func (param f64) (result (ref null $=>eqref))))
  ;; CHECK-TEXT:      (type $i32-i32 (func (param i32) (result i32)))

  ;; CHECK-TEXT:      (type $3 (func (param (ref $i32-i32)) (result i32)))

  ;; CHECK-TEXT:      (type $4 (func (param (ref null $i32-i32)) (result i32)))

  ;; CHECK-TEXT:      (type $5 (func (result i32)))

  ;; CHECK-TEXT:      (type $=>eqref (func (result eqref)))

  ;; CHECK-TEXT:      (type $f64_=>_ref_null<_->_eqref> (func (param f64) (result (ref null $=>eqref))))
  (type $f64_=>_ref_null<_->_eqref> (func (param f64) (result (ref null $_=>_eqref))))
  (type $=>eqref (func (result eqref)))
  ;; CHECK-BINARY:      (type $=>anyref (func (result anyref)))
  ;; CHECK-TEXT:      (type $=>anyref (func (result anyref)))
  (type $=>anyref (func (result anyref)))
  (type $mixed_results (func (result anyref f32 anyref f32)))

  (type $i32-i32 (func (param i32) (result i32)))

  ;; CHECK-BINARY:      (type $9 (func (result i32 (ref null $mixed_results) f64)))

  ;; CHECK-BINARY:      (type $10 (func (param (ref null $mixed_results))))

  ;; CHECK-BINARY:      (elem declare func $call-ref $call-ref-more)

  ;; CHECK-BINARY:      (func $call-ref (type $void)
  ;; CHECK-BINARY-NEXT:  (call_ref $void
  ;; CHECK-BINARY-NEXT:   (ref.func $call-ref)
  ;; CHECK-BINARY-NEXT:  )
  ;; CHECK-BINARY-NEXT: )
  ;; CHECK-TEXT:      (type $9 (func (result i32 (ref null $mixed_results) f64)))

  ;; CHECK-TEXT:      (type $10 (func (param (ref null $mixed_results))))

  ;; CHECK-TEXT:      (elem declare func $call-ref $call-ref-more)

  ;; CHECK-TEXT:      (func $call-ref (type $void)
  ;; CHECK-TEXT-NEXT:  (call_ref $void
  ;; CHECK-TEXT-NEXT:   (ref.func $call-ref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  (func $call-ref
    (call_ref $void (ref.func $call-ref))
  )
  ;; CHECK-BINARY:      (func $return-call-ref (type $void)
  ;; CHECK-BINARY-NEXT:  (return_call_ref $void
  ;; CHECK-BINARY-NEXT:   (ref.func $call-ref)
  ;; CHECK-BINARY-NEXT:  )
  ;; CHECK-BINARY-NEXT: )
  ;; CHECK-TEXT:      (func $return-call-ref (type $void)
  ;; CHECK-TEXT-NEXT:  (return_call_ref $void
  ;; CHECK-TEXT-NEXT:   (ref.func $call-ref)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  (func $return-call-ref
    (return_call_ref $void (ref.func $call-ref))
  )
  ;; CHECK-BINARY:      (func $call-ref-more (type $i32-i32) (param $0 i32) (result i32)
  ;; CHECK-BINARY-NEXT:  (call_ref $i32-i32
  ;; CHECK-BINARY-NEXT:   (i32.const 42)
  ;; CHECK-BINARY-NEXT:   (ref.func $call-ref-more)
  ;; CHECK-BINARY-NEXT:  )
  ;; CHECK-BINARY-NEXT: )
  ;; CHECK-TEXT:      (func $call-ref-more (type $i32-i32) (param $0 i32) (result i32)
  ;; CHECK-TEXT-NEXT:  (call_ref $i32-i32
  ;; CHECK-TEXT-NEXT:   (i32.const 42)
  ;; CHECK-TEXT-NEXT:   (ref.func $call-ref-more)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  (func $call-ref-more (param i32) (result i32)
    (call_ref $i32-i32 (i32.const 42) (ref.func $call-ref-more))
  )
  ;; CHECK-BINARY:      (func $call_from-param (type $3) (param $f (ref $i32-i32)) (result i32)
  ;; CHECK-BINARY-NEXT:  (call_ref $i32-i32
  ;; CHECK-BINARY-NEXT:   (i32.const 42)
  ;; CHECK-BINARY-NEXT:   (local.get $f)
  ;; CHECK-BINARY-NEXT:  )
  ;; CHECK-BINARY-NEXT: )
  ;; CHECK-TEXT:      (func $call_from-param (type $3) (param $f (ref $i32-i32)) (result i32)
  ;; CHECK-TEXT-NEXT:  (call_ref $i32-i32
  ;; CHECK-TEXT-NEXT:   (i32.const 42)
  ;; CHECK-TEXT-NEXT:   (local.get $f)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  (func $call_from-param (param $f (ref $i32-i32)) (result i32)
    (call_ref $i32-i32 (i32.const 42) (local.get $f))
  )
  ;; CHECK-BINARY:      (func $call_from-param-null (type $4) (param $f (ref null $i32-i32)) (result i32)
  ;; CHECK-BINARY-NEXT:  (call_ref $i32-i32
  ;; CHECK-BINARY-NEXT:   (i32.const 42)
  ;; CHECK-BINARY-NEXT:   (local.get $f)
  ;; CHECK-BINARY-NEXT:  )
  ;; CHECK-BINARY-NEXT: )
  ;; CHECK-TEXT:      (func $call_from-param-null (type $4) (param $f (ref null $i32-i32)) (result i32)
  ;; CHECK-TEXT-NEXT:  (call_ref $i32-i32
  ;; CHECK-TEXT-NEXT:   (i32.const 42)
  ;; CHECK-TEXT-NEXT:   (local.get $f)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  (func $call_from-param-null (param $f (ref null $i32-i32)) (result i32)
    (call_ref $i32-i32 (i32.const 42) (local.get $f))
  )
  ;; CHECK-BINARY:      (func $call_from-local-null (type $5) (result i32)
  ;; CHECK-BINARY-NEXT:  (local $f (ref null $i32-i32))
  ;; CHECK-BINARY-NEXT:  (local.set $f
  ;; CHECK-BINARY-NEXT:   (ref.func $call-ref-more)
  ;; CHECK-BINARY-NEXT:  )
  ;; CHECK-BINARY-NEXT:  (call_ref $i32-i32
  ;; CHECK-BINARY-NEXT:   (i32.const 42)
  ;; CHECK-BINARY-NEXT:   (local.get $f)
  ;; CHECK-BINARY-NEXT:  )
  ;; CHECK-BINARY-NEXT: )
  ;; CHECK-TEXT:      (func $call_from-local-null (type $5) (result i32)
  ;; CHECK-TEXT-NEXT:  (local $f (ref null $i32-i32))
  ;; CHECK-TEXT-NEXT:  (local.set $f
  ;; CHECK-TEXT-NEXT:   (ref.func $call-ref-more)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (call_ref $i32-i32
  ;; CHECK-TEXT-NEXT:   (i32.const 42)
  ;; CHECK-TEXT-NEXT:   (local.get $f)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  (func $call_from-local-null (result i32)
    (local $f (ref null $i32-i32))
    (local.set $f (ref.func $call-ref-more))
    (call_ref $i32-i32 (i32.const 42) (local.get $f))
  )
  ;; CHECK-BINARY:      (func $ref-in-sig (type $f64_=>_ref_null<_->_eqref>) (param $0 f64) (result (ref null $=>eqref))
  ;; CHECK-BINARY-NEXT:  (ref.null nofunc)
  ;; CHECK-BINARY-NEXT: )
  ;; CHECK-TEXT:      (func $ref-in-sig (type $f64_=>_ref_null<_->_eqref>) (param $0 f64) (result (ref null $=>eqref))
  ;; CHECK-TEXT-NEXT:  (ref.null nofunc)
  ;; CHECK-TEXT-NEXT: )
  (func $ref-in-sig (param $0 f64) (result (ref null $=>eqref))
    (ref.null $=>eqref)
  )
  ;; CHECK-BINARY:      (func $type-only-in-tuple-local (type $void)
  ;; CHECK-BINARY-NEXT:  (local $x i32)
  ;; CHECK-BINARY-NEXT:  (local $1 f64)
  ;; CHECK-BINARY-NEXT:  (local $2 (ref null $=>anyref))
  ;; CHECK-BINARY-NEXT:  (nop)
  ;; CHECK-BINARY-NEXT: )
  ;; CHECK-TEXT:      (func $type-only-in-tuple-local (type $void)
  ;; CHECK-TEXT-NEXT:  (local $x i32)
  ;; CHECK-TEXT-NEXT:  (local $1 f64)
  ;; CHECK-TEXT-NEXT:  (local $2 (ref null $=>anyref))
  ;; CHECK-TEXT-NEXT:  (nop)
  ;; CHECK-TEXT-NEXT: )
  (func $type-only-in-tuple-local
    (local $x (i32 (ref null $=>anyref) f64))
  )
  ;; CHECK-BINARY:      (func $type-only-in-tuple-block (type $void)
  ;; CHECK-BINARY-NEXT:  (local $0 (i32 (ref null $mixed_results) f64))
  ;; CHECK-BINARY-NEXT:  (local $1 (ref null $mixed_results))
  ;; CHECK-BINARY-NEXT:  (local $2 i32)
  ;; CHECK-BINARY-NEXT:  (local.set $0
  ;; CHECK-BINARY-NEXT:   (block $label$1 (result i32 (ref null $mixed_results) f64)
  ;; CHECK-BINARY-NEXT:    (unreachable)
  ;; CHECK-BINARY-NEXT:   )
  ;; CHECK-BINARY-NEXT:  )
  ;; CHECK-BINARY-NEXT:  (drop
  ;; CHECK-BINARY-NEXT:   (block (result i32)
  ;; CHECK-BINARY-NEXT:    (local.set $2
  ;; CHECK-BINARY-NEXT:     (tuple.extract 0
  ;; CHECK-BINARY-NEXT:      (local.get $0)
  ;; CHECK-BINARY-NEXT:     )
  ;; CHECK-BINARY-NEXT:    )
  ;; CHECK-BINARY-NEXT:    (drop
  ;; CHECK-BINARY-NEXT:     (block (result (ref null $mixed_results))
  ;; CHECK-BINARY-NEXT:      (local.set $1
  ;; CHECK-BINARY-NEXT:       (tuple.extract 1
  ;; CHECK-BINARY-NEXT:        (local.get $0)
  ;; CHECK-BINARY-NEXT:       )
  ;; CHECK-BINARY-NEXT:      )
  ;; CHECK-BINARY-NEXT:      (drop
  ;; CHECK-BINARY-NEXT:       (tuple.extract 2
  ;; CHECK-BINARY-NEXT:        (local.get $0)
  ;; CHECK-BINARY-NEXT:       )
  ;; CHECK-BINARY-NEXT:      )
  ;; CHECK-BINARY-NEXT:      (local.get $1)
  ;; CHECK-BINARY-NEXT:     )
  ;; CHECK-BINARY-NEXT:    )
  ;; CHECK-BINARY-NEXT:    (local.get $2)
  ;; CHECK-BINARY-NEXT:   )
  ;; CHECK-BINARY-NEXT:  )
  ;; CHECK-BINARY-NEXT: )
  ;; CHECK-TEXT:      (func $type-only-in-tuple-block (type $void)
  ;; CHECK-TEXT-NEXT:  (local $0 (i32 (ref null $mixed_results) f64))
  ;; CHECK-TEXT-NEXT:  (local $1 (ref null $mixed_results))
  ;; CHECK-TEXT-NEXT:  (local $2 i32)
  ;; CHECK-TEXT-NEXT:  (local.set $0
  ;; CHECK-TEXT-NEXT:   (block $label$1 (result i32 (ref null $mixed_results) f64)
  ;; CHECK-TEXT-NEXT:    (unreachable)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (block (result i32)
  ;; CHECK-TEXT-NEXT:    (local.set $2
  ;; CHECK-TEXT-NEXT:     (tuple.extract 0
  ;; CHECK-TEXT-NEXT:      (local.get $0)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (drop
  ;; CHECK-TEXT-NEXT:     (block (result (ref null $mixed_results))
  ;; CHECK-TEXT-NEXT:      (local.set $1
  ;; CHECK-TEXT-NEXT:       (tuple.extract 1
  ;; CHECK-TEXT-NEXT:        (local.get $0)
  ;; CHECK-TEXT-NEXT:       )
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:      (drop
  ;; CHECK-TEXT-NEXT:       (tuple.extract 2
  ;; CHECK-TEXT-NEXT:        (local.get $0)
  ;; CHECK-TEXT-NEXT:       )
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:      (local.get $1)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (local.get $2)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  (func $type-only-in-tuple-block
    (drop
      (block $block (result i32 (ref null $mixed_results) f64)
        (unreachable)
      )
    )
  )
  ;; CHECK-BINARY:      (func $ref-types-first (type $void)
  ;; CHECK-BINARY-NEXT:  (local $r1 (ref null $mixed_results))
  ;; CHECK-BINARY-NEXT:  (local $r2 (ref null $mixed_results))
  ;; CHECK-BINARY-NEXT:  (local $r3 anyref)
  ;; CHECK-BINARY-NEXT:  (local $r4 anyref)
  ;; CHECK-BINARY-NEXT:  (local $r5 anyref)
  ;; CHECK-BINARY-NEXT:  (local $r6 funcref)
  ;; CHECK-BINARY-NEXT:  (local $i1 i32)
  ;; CHECK-BINARY-NEXT:  (local $i2 i64)
  ;; CHECK-BINARY-NEXT:  (local $i3 i64)
  ;; CHECK-BINARY-NEXT:  (nop)
  ;; CHECK-BINARY-NEXT: )
  ;; CHECK-TEXT:      (func $ref-types-first (type $void)
  ;; CHECK-TEXT-NEXT:  (local $r1 (ref null $mixed_results))
  ;; CHECK-TEXT-NEXT:  (local $r2 (ref null $mixed_results))
  ;; CHECK-TEXT-NEXT:  (local $r3 anyref)
  ;; CHECK-TEXT-NEXT:  (local $r4 anyref)
  ;; CHECK-TEXT-NEXT:  (local $r5 anyref)
  ;; CHECK-TEXT-NEXT:  (local $r6 funcref)
  ;; CHECK-TEXT-NEXT:  (local $i1 i32)
  ;; CHECK-TEXT-NEXT:  (local $i2 i64)
  ;; CHECK-TEXT-NEXT:  (local $i3 i64)
  ;; CHECK-TEXT-NEXT:  (nop)
  ;; CHECK-TEXT-NEXT: )
  (func $ref-types-first
    ;; 6 reference types and 3 MVP types. The binary format should emit all the
    ;; reference types first since a reference type appears first. In addition,
    ;; types should be emitted in blocks there, that is, locals of identical
    ;; types should be adjacent.
    (local $r1 (ref null $mixed_results))
    (local $r2 (ref null $mixed_results))
    (local $i1 i32)
    (local $r3 anyref)
    (local $i2 i64)
    (local $r4 anyref)
    (local $i3 i64)
    (local $r5 anyref)
    (local $r6 funcref)
  )
  ;; CHECK-BINARY:      (func $mvp-types-first (type $void)
  ;; CHECK-BINARY-NEXT:  (local $i1 i32)
  ;; CHECK-BINARY-NEXT:  (local $i2 i64)
  ;; CHECK-BINARY-NEXT:  (local $i3 i64)
  ;; CHECK-BINARY-NEXT:  (local $r1 (ref null $mixed_results))
  ;; CHECK-BINARY-NEXT:  (local $r2 (ref null $mixed_results))
  ;; CHECK-BINARY-NEXT:  (local $r3 anyref)
  ;; CHECK-BINARY-NEXT:  (local $r4 anyref)
  ;; CHECK-BINARY-NEXT:  (local $r5 anyref)
  ;; CHECK-BINARY-NEXT:  (local $r6 funcref)
  ;; CHECK-BINARY-NEXT:  (nop)
  ;; CHECK-BINARY-NEXT: )
  ;; CHECK-TEXT:      (func $mvp-types-first (type $void)
  ;; CHECK-TEXT-NEXT:  (local $i1 i32)
  ;; CHECK-TEXT-NEXT:  (local $i2 i64)
  ;; CHECK-TEXT-NEXT:  (local $i3 i64)
  ;; CHECK-TEXT-NEXT:  (local $r1 (ref null $mixed_results))
  ;; CHECK-TEXT-NEXT:  (local $r2 (ref null $mixed_results))
  ;; CHECK-TEXT-NEXT:  (local $r3 anyref)
  ;; CHECK-TEXT-NEXT:  (local $r4 anyref)
  ;; CHECK-TEXT-NEXT:  (local $r5 anyref)
  ;; CHECK-TEXT-NEXT:  (local $r6 funcref)
  ;; CHECK-TEXT-NEXT:  (nop)
  ;; CHECK-TEXT-NEXT: )
  (func $mvp-types-first
    ;; Reversed from before, now an MVP type appears first, so they should all
    ;; be before reference types in the binary format.
    (local $i1 i32) ;; only this local was moved up.
    (local $r1 (ref null $mixed_results))
    (local $r2 (ref null $mixed_results))
    (local $r3 anyref)
    (local $i2 i64)
    (local $r4 anyref)
    (local $i3 i64)
    (local $r5 anyref)
    (local $r6 funcref)
  )
  ;; CHECK-BINARY:      (func $mvp-types-first-param (type $10) (param $r0 (ref null $mixed_results))
  ;; CHECK-BINARY-NEXT:  (local $i1 i32)
  ;; CHECK-BINARY-NEXT:  (local $i2 i64)
  ;; CHECK-BINARY-NEXT:  (local $i3 i64)
  ;; CHECK-BINARY-NEXT:  (local $r1 (ref null $mixed_results))
  ;; CHECK-BINARY-NEXT:  (local $r2 (ref null $mixed_results))
  ;; CHECK-BINARY-NEXT:  (local $r3 anyref)
  ;; CHECK-BINARY-NEXT:  (local $r4 anyref)
  ;; CHECK-BINARY-NEXT:  (local $r5 anyref)
  ;; CHECK-BINARY-NEXT:  (local $r6 funcref)
  ;; CHECK-BINARY-NEXT:  (nop)
  ;; CHECK-BINARY-NEXT: )
  ;; CHECK-TEXT:      (func $mvp-types-first-param (type $10) (param $r0 (ref null $mixed_results))
  ;; CHECK-TEXT-NEXT:  (local $i1 i32)
  ;; CHECK-TEXT-NEXT:  (local $i2 i64)
  ;; CHECK-TEXT-NEXT:  (local $i3 i64)
  ;; CHECK-TEXT-NEXT:  (local $r1 (ref null $mixed_results))
  ;; CHECK-TEXT-NEXT:  (local $r2 (ref null $mixed_results))
  ;; CHECK-TEXT-NEXT:  (local $r3 anyref)
  ;; CHECK-TEXT-NEXT:  (local $r4 anyref)
  ;; CHECK-TEXT-NEXT:  (local $r5 anyref)
  ;; CHECK-TEXT-NEXT:  (local $r6 funcref)
  ;; CHECK-TEXT-NEXT:  (nop)
  ;; CHECK-TEXT-NEXT: )
  (func $mvp-types-first-param (param $r0 (ref null $mixed_results))
    ;; As before, but now there is a reference type *parameter*. We should
    ;; ignore that and sort as in the last function.
    (local $i1 i32) ;; only this local was moved up.
    (local $r1 (ref null $mixed_results))
    (local $r2 (ref null $mixed_results))
    (local $r3 anyref)
    (local $i2 i64)
    (local $r4 anyref)
    (local $i3 i64)
    (local $r5 anyref)
    (local $r6 funcref)
  )
)
;; CHECK-NODEBUG:      (type $0 (func (result anyref f32 anyref f32)))

;; CHECK-NODEBUG:      (type $1 (func))

;; CHECK-NODEBUG:      (type $2 (func (param i32) (result i32)))

;; CHECK-NODEBUG:      (type $3 (func (param (ref $2)) (result i32)))

;; CHECK-NODEBUG:      (type $4 (func (param (ref null $2)) (result i32)))

;; CHECK-NODEBUG:      (type $5 (func (result i32)))

;; CHECK-NODEBUG:      (type $6 (func (result eqref)))

;; CHECK-NODEBUG:      (type $7 (func (param f64) (result (ref null $6))))

;; CHECK-NODEBUG:      (type $8 (func (result anyref)))

;; CHECK-NODEBUG:      (type $9 (func (result i32 (ref null $0) f64)))

;; CHECK-NODEBUG:      (type $10 (func (param (ref null $0))))

;; CHECK-NODEBUG:      (elem declare func $0 $2)

;; CHECK-NODEBUG:      (func $0 (type $1)
;; CHECK-NODEBUG-NEXT:  (call_ref $1
;; CHECK-NODEBUG-NEXT:   (ref.func $0)
;; CHECK-NODEBUG-NEXT:  )
;; CHECK-NODEBUG-NEXT: )

;; CHECK-NODEBUG:      (func $1 (type $1)
;; CHECK-NODEBUG-NEXT:  (return_call_ref $1
;; CHECK-NODEBUG-NEXT:   (ref.func $0)
;; CHECK-NODEBUG-NEXT:  )
;; CHECK-NODEBUG-NEXT: )

;; CHECK-NODEBUG:      (func $2 (type $2) (param $0 i32) (result i32)
;; CHECK-NODEBUG-NEXT:  (call_ref $2
;; CHECK-NODEBUG-NEXT:   (i32.const 42)
;; CHECK-NODEBUG-NEXT:   (ref.func $2)
;; CHECK-NODEBUG-NEXT:  )
;; CHECK-NODEBUG-NEXT: )

;; CHECK-NODEBUG:      (func $3 (type $3) (param $0 (ref $2)) (result i32)
;; CHECK-NODEBUG-NEXT:  (call_ref $2
;; CHECK-NODEBUG-NEXT:   (i32.const 42)
;; CHECK-NODEBUG-NEXT:   (local.get $0)
;; CHECK-NODEBUG-NEXT:  )
;; CHECK-NODEBUG-NEXT: )

;; CHECK-NODEBUG:      (func $4 (type $4) (param $0 (ref null $2)) (result i32)
;; CHECK-NODEBUG-NEXT:  (call_ref $2
;; CHECK-NODEBUG-NEXT:   (i32.const 42)
;; CHECK-NODEBUG-NEXT:   (local.get $0)
;; CHECK-NODEBUG-NEXT:  )
;; CHECK-NODEBUG-NEXT: )

;; CHECK-NODEBUG:      (func $5 (type $5) (result i32)
;; CHECK-NODEBUG-NEXT:  (local $0 (ref null $2))
;; CHECK-NODEBUG-NEXT:  (local.set $0
;; CHECK-NODEBUG-NEXT:   (ref.func $2)
;; CHECK-NODEBUG-NEXT:  )
;; CHECK-NODEBUG-NEXT:  (call_ref $2
;; CHECK-NODEBUG-NEXT:   (i32.const 42)
;; CHECK-NODEBUG-NEXT:   (local.get $0)
;; CHECK-NODEBUG-NEXT:  )
;; CHECK-NODEBUG-NEXT: )

;; CHECK-NODEBUG:      (func $6 (type $7) (param $0 f64) (result (ref null $6))
;; CHECK-NODEBUG-NEXT:  (ref.null nofunc)
;; CHECK-NODEBUG-NEXT: )

;; CHECK-NODEBUG:      (func $7 (type $1)
;; CHECK-NODEBUG-NEXT:  (local $0 i32)
;; CHECK-NODEBUG-NEXT:  (local $1 f64)
;; CHECK-NODEBUG-NEXT:  (local $2 (ref null $8))
;; CHECK-NODEBUG-NEXT:  (nop)
;; CHECK-NODEBUG-NEXT: )

;; CHECK-NODEBUG:      (func $8 (type $1)
;; CHECK-NODEBUG-NEXT:  (local $0 (i32 (ref null $0) f64))
;; CHECK-NODEBUG-NEXT:  (local $1 (ref null $0))
;; CHECK-NODEBUG-NEXT:  (local $2 i32)
;; CHECK-NODEBUG-NEXT:  (local.set $0
;; CHECK-NODEBUG-NEXT:   (block $label$1 (result i32 (ref null $0) f64)
;; CHECK-NODEBUG-NEXT:    (unreachable)
;; CHECK-NODEBUG-NEXT:   )
;; CHECK-NODEBUG-NEXT:  )
;; CHECK-NODEBUG-NEXT:  (drop
;; CHECK-NODEBUG-NEXT:   (block (result i32)
;; CHECK-NODEBUG-NEXT:    (local.set $2
;; CHECK-NODEBUG-NEXT:     (tuple.extract 0
;; CHECK-NODEBUG-NEXT:      (local.get $0)
;; CHECK-NODEBUG-NEXT:     )
;; CHECK-NODEBUG-NEXT:    )
;; CHECK-NODEBUG-NEXT:    (drop
;; CHECK-NODEBUG-NEXT:     (block (result (ref null $0))
;; CHECK-NODEBUG-NEXT:      (local.set $1
;; CHECK-NODEBUG-NEXT:       (tuple.extract 1
;; CHECK-NODEBUG-NEXT:        (local.get $0)
;; CHECK-NODEBUG-NEXT:       )
;; CHECK-NODEBUG-NEXT:      )
;; CHECK-NODEBUG-NEXT:      (drop
;; CHECK-NODEBUG-NEXT:       (tuple.extract 2
;; CHECK-NODEBUG-NEXT:        (local.get $0)
;; CHECK-NODEBUG-NEXT:       )
;; CHECK-NODEBUG-NEXT:      )
;; CHECK-NODEBUG-NEXT:      (local.get $1)
;; CHECK-NODEBUG-NEXT:     )
;; CHECK-NODEBUG-NEXT:    )
;; CHECK-NODEBUG-NEXT:    (local.get $2)
;; CHECK-NODEBUG-NEXT:   )
;; CHECK-NODEBUG-NEXT:  )
;; CHECK-NODEBUG-NEXT: )

;; CHECK-NODEBUG:      (func $9 (type $1)
;; CHECK-NODEBUG-NEXT:  (local $0 (ref null $0))
;; CHECK-NODEBUG-NEXT:  (local $1 (ref null $0))
;; CHECK-NODEBUG-NEXT:  (local $2 anyref)
;; CHECK-NODEBUG-NEXT:  (local $3 anyref)
;; CHECK-NODEBUG-NEXT:  (local $4 anyref)
;; CHECK-NODEBUG-NEXT:  (local $5 funcref)
;; CHECK-NODEBUG-NEXT:  (local $6 i32)
;; CHECK-NODEBUG-NEXT:  (local $7 i64)
;; CHECK-NODEBUG-NEXT:  (local $8 i64)
;; CHECK-NODEBUG-NEXT:  (nop)
;; CHECK-NODEBUG-NEXT: )

;; CHECK-NODEBUG:      (func $10 (type $1)
;; CHECK-NODEBUG-NEXT:  (local $0 i32)
;; CHECK-NODEBUG-NEXT:  (local $1 i64)
;; CHECK-NODEBUG-NEXT:  (local $2 i64)
;; CHECK-NODEBUG-NEXT:  (local $3 (ref null $0))
;; CHECK-NODEBUG-NEXT:  (local $4 (ref null $0))
;; CHECK-NODEBUG-NEXT:  (local $5 anyref)
;; CHECK-NODEBUG-NEXT:  (local $6 anyref)
;; CHECK-NODEBUG-NEXT:  (local $7 anyref)
;; CHECK-NODEBUG-NEXT:  (local $8 funcref)
;; CHECK-NODEBUG-NEXT:  (nop)
;; CHECK-NODEBUG-NEXT: )

;; CHECK-NODEBUG:      (func $11 (type $10) (param $0 (ref null $0))
;; CHECK-NODEBUG-NEXT:  (local $1 i32)
;; CHECK-NODEBUG-NEXT:  (local $2 i64)
;; CHECK-NODEBUG-NEXT:  (local $3 i64)
;; CHECK-NODEBUG-NEXT:  (local $4 (ref null $0))
;; CHECK-NODEBUG-NEXT:  (local $5 (ref null $0))
;; CHECK-NODEBUG-NEXT:  (local $6 anyref)
;; CHECK-NODEBUG-NEXT:  (local $7 anyref)
;; CHECK-NODEBUG-NEXT:  (local $8 anyref)
;; CHECK-NODEBUG-NEXT:  (local $9 funcref)
;; CHECK-NODEBUG-NEXT:  (nop)
;; CHECK-NODEBUG-NEXT: )
