;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; RUN: wasm-opt %s --jspi --pass-arg=jspi-imports@js.sleep_async --pass-arg=jspi-exports@update_state_async -all -S -o - | filecheck %s

(module
  ;; sleep_async should have a wrapper function built.
  ;; CHECK:      (type $0 (func (param f64) (result i32)))

  ;; CHECK:      (type $1 (func (param externref f64) (result i32)))

  ;; CHECK:      (import "js" "sleep_sync" (func $sleep_sync (type $0) (param f64) (result i32)))
  (import "js" "sleep_async" (func $sleep_async (param f64) (result i32)))
  ;; CHECK:      (import "js" "sleep_async" (func $import$sleep_async (type $1) (param externref f64) (result i32)))
  (import "js" "sleep_sync" (func $sleep_sync (param f64) (result i32)))
  ;; CHECK:      (global $suspender (mut externref) (ref.null noextern))

  ;; CHECK:      (export "update_state_async" (func $export$update_state_async))
  (export "update_state_async" (func $update_state_async))
  ;; CHECK:      (export "update_state_sync" (func $update_state_sync))
  (export "update_state_sync" (func $update_state_sync))
  ;; This function calls an async sleep so a wrapper should be created for it.
  ;; CHECK:      (func $update_state_async (type $0) (param $param f64) (result i32)
  ;; CHECK-NEXT:  (call $sleep_async
  ;; CHECK-NEXT:   (f64.sub
  ;; CHECK-NEXT:    (f64.const 1.1)
  ;; CHECK-NEXT:    (local.get $param)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $update_state_async (param $param f64) (result i32)
    (call $sleep_async (f64.sub (f64.const 1.1) (local.get $param)))
  )
  ;; CHECK:      (func $update_state_sync (type $0) (param $param f64) (result i32)
  ;; CHECK-NEXT:  (call $sleep_sync
  ;; CHECK-NEXT:   (f64.sub
  ;; CHECK-NEXT:    (f64.const 1.1)
  ;; CHECK-NEXT:    (local.get $param)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $update_state_sync (param $param f64) (result i32)
    (call $sleep_sync (f64.sub (f64.const 1.1) (local.get $param)))
  )
)
;; CHECK:      (func $export$update_state_async (type $1) (param $susp externref) (param $param f64) (result i32)
;; CHECK-NEXT:  (global.set $suspender
;; CHECK-NEXT:   (local.get $susp)
;; CHECK-NEXT:  )
;; CHECK-NEXT:  (call $update_state_async
;; CHECK-NEXT:   (local.get $param)
;; CHECK-NEXT:  )
;; CHECK-NEXT: )

;; CHECK:      (func $sleep_async (type $0) (param $0 f64) (result i32)
;; CHECK-NEXT:  (local $1 externref)
;; CHECK-NEXT:  (local $2 i32)
;; CHECK-NEXT:  (local.set $1
;; CHECK-NEXT:   (global.get $suspender)
;; CHECK-NEXT:  )
;; CHECK-NEXT:  (local.set $2
;; CHECK-NEXT:   (call $import$sleep_async
;; CHECK-NEXT:    (global.get $suspender)
;; CHECK-NEXT:    (local.get $0)
;; CHECK-NEXT:   )
;; CHECK-NEXT:  )
;; CHECK-NEXT:  (global.set $suspender
;; CHECK-NEXT:   (local.get $1)
;; CHECK-NEXT:  )
;; CHECK-NEXT:  (local.get $2)
;; CHECK-NEXT: )
