      SUBROUTINE ksorensenRFFTF( X, N, M, S1, C1, S3, C3, Nmax )
c
c  A real-valued, in place, split-radix FFT program
c  Real input and output in data array X
c  Length is N = 2 ** M <= Nmax
c  Decimation-in-time, cos/sin in second loop with table look-up
c  Output in order:
c         [ Re(0), Re(1), ..., Re(N/2), Im(N/2-1), ..., Im(1) ]
c
c  S1 - array of sin() table (length >= Nmax/8-1)
c  C1 - array of cos() table (length >= Nmax/8-1)
c  S3 - array of sin() table (length >= Nmax/8-1)
c  C3 - array of cos() table (length >= Nmax/8-1)
c
c  The sine/cosine tables were initialized assuming a transform
c  length of Nmax (a power of two).
c
c  The initialization routine FFTI must be called prior to calling
c  this routine.  FFTI need not be called again unless Nmax is made
c  larger.
c  In place bit reversal is accomplished by calling BITREV.
c
c  This routine requires approximately 2*N*M-4*N floating point operations.
c
c 
c  Original code (RVFFT) written by H.V. Sorensen, 
c                                   Rice University, Oct. 1985
c
c  Reference:  H.V. Sorensen, D.L. Jones, M.T. Heideman, & C.S. Burrus;
c              Real-Valued Fast Fourier Transform Algorithms; IEEE
c              Trans. Acoust., Speech, Signal Process.; Vol ASSP-35,
c              June 1987, pp. 849-863.
c
c  Modifications made by Steve Kifowit.
c     - cosmetic changes -- 6/22/97
c     - quick return for N=1 -- 6/22/97
c     - table lookup of sines and cosines -- 6/22/97
c     - bit reversal by calling BITREV -- 12/22/97
c
c
c ... Scalar arguments ...
      INTEGER N, M, Nmax
c ... Array arguments ...
      DOUBLE PRECISION  X(*), S1(*), C1(*), S3(*), C3(*)
c ... Local scalars ...
      INTEGER  J, I, K, IS, ID
      INTEGER  I0, I1, I2, I3, I4, I5, I6, I7, I8
      INTEGER  N2, N4, N8, NN, IT, ITS, NRATIO
      DOUBLE PRECISION  R1, T1, T2, T3, T4, T5, T6
c ... Parameters ...
      DOUBLE PRECISION SQRT2
      PARAMETER ( SQRT2 = 1.4142135623730950488D0 )
c
c ... Exe. statements ...
c
      IF ( N .EQ. 1 ) RETURN
c
      CALL KSORENSENBITREV( X, N )
c
      NRATIO = Nmax / N
      IS = 1
      ID = 4
 70   DO 60, I0 = IS, N, ID
         I1 = I0 + 1
         R1 = X(I0)
         X(I0) = R1 + X(I1)
         X(I1) = R1 - X(I1)
 60   CONTINUE
      IS = 2 * ID - 1
      ID = 4 * ID
      IF ( IS .LT. N ) GOTO 70
c
      N2 = 2
      NN = N / 2
      DO 10, K = 2, M
         N2 = N2 * 2
         N4 = N2 / 4
         N8 = N2 / 8
	 NN = NN / 2
         IS = 0
         ID = N2 * 2
 40      DO 38, I = IS, N-1, ID
            I1 = I + 1
            I2 = I1 + N4
            I3 = I2 + N4
            I4 = I3 + N4
            T1 = X(I4) + X(I3)
            X(I4) = X(I4) - X(I3)
            X(I3) = X(I1) - T1
            X(I1) = X(I1) + T1
            IF ( N4 .EQ. 1 ) GOTO 38
            I1 = I1 + N8
            I2 = I2 + N8
            I3 = I3 + N8
            I4 = I4 + N8
            T1 = ( X(I3) + X(I4) ) / SQRT2
            T2 = ( X(I3) - X(I4) ) / SQRT2
            X(I4) = X(I2) - T1
            X(I3) = - X(I2) - T1
            X(I2) = X(I1) - T2
            X(I1) = X(I1) + T2
 38      CONTINUE
         IS = 2 * ID - N2
         ID = 4 * ID
         IF ( IS .LT. N ) GOTO 40
	 IT = 0
	 ITS = NN * NRATIO
         DO 32, J = 2, N8
	    IT = IT + ITS
            IS = 0
            ID = 2 * N2
 36         DO 30, I = IS, N-1, ID
               I1 = I + J
               I2 = I1 + N4
               I3 = I2 + N4
               I4 = I3 + N4
               I5 = I + N4 - J + 2
               I6 = I5 + N4
               I7 = I6 + N4
               I8 = I7 + N4
               T1 = X(I3) * C1(IT) + X(I7) * S1(IT)
               T2 = X(I7) * C1(IT) - X(I3) * S1(IT) 
               T3 = X(I4) * C3(IT) + X(I8) * S3(IT)
               T4 = X(I8) * C3(IT) - X(I4) * S3(IT)
               T5 = T1 + T3
               T6 = T2 + T4
               T3 = T1 - T3
               T4 = T2 - T4
               T2 = X(I6) + T6
               X(I3) = T6 - X(I6) 
               X(I8) = T2
               T2 = X(I2) - T3
               X(I7) = - X(I2) - T3
               X(I4) = T2
               T1 = X(I1) + T5
               X(I6) = X(I1) - T5
               X(I1) = T1
               T1 = X(I5) + T4
               X(I5) = X(I5) - T4
               X(I2) = T1
 30         CONTINUE
            IS = 2 * ID - N2
            ID = 4 * ID
            IF ( IS .LT. N ) GOTO 36
 32      CONTINUE
 10   CONTINUE
      RETURN
c
c ... End of subroutine RFFTF ...
c
      END

