      SUBROUTINE ksorensenRFFTB( X, N, M, S1, C1, S3, C3, Nmax )
c
c  A real-valued, in place, split-radix IFFT program
c  Hermitian symmetric input and real output in array X
c  Length is N = 2 ** M <= Nmax
c  Decimation-in-frequency, cos/sin in second loop with table look-up
c  Input order:
c         [ Re(0), Re(1), ..., Re(N/2), Im(N/2-1), ..., Im(1) ]
c
c  S1 - array of sin() table (length >= Nmax/8-1)
c  C1 - array of cos() table (length >= Nmax/8-1)
c  S3 - array of sin() table (length >= Nmax/8-1)
c  C3 - array of cos() table (length >= Nmax/8-1)
c
c  The sine/cosine tables were initialized assuming a transform
c  length of Nmax (a power of two).
c
c  The initialization routine FFTI must be called prior to calling
c  this routine.  FFTI need not be called again unless Nmax is made
c  larger.
c  In place bit reversal is accomplished by calling BITREV.
c 
c  This routine requires approximately 2*N*M-3*N floating point operations.
c 
c
c  Original code (IRVFFT) written by H.V. Sorensen, 
c                                    Rice University, Oct. 1985
c
c  Reference:  H.V. Sorensen, D.L. Jones, M.T. Heideman, & C.S. Burrus;
c              Real-Valued Fast Fourier Transform Algorithms; IEEE
c              Trans. Acoust., Speech, Signal Process.; Vol ASSP-35,
c              June 1987, pp. 849-863.
c
c  Modifications made by Steve Kifowit.
c     - cosmetic changes -- 6/22/97
c     - quick return for N=1 -- 6/22/97
c     - table lookup of sines and cosines -- 6/22/97
c     - bit reversal by calling BITREV -- 12/22/97
c
c
c ... Scalar arguments ...
      INTEGER N, M, Nmax
c ... Array arguments ...
      DOUBLE PRECISION  X(*), S1(*), C1(*), S3(*), C3(*)
c ... Local scalars ...
      INTEGER  J, I, K, IS, ID, I0, I1, I2, I3, I4, I5, I6, I7, I8
      INTEGER  N2, N4, N8, NN, IT, ITS, NRATIO
      DOUBLE PRECISION  R1, T1, T2, T3, T4, T5
c ... Parameters ...
      DOUBLE PRECISION  SQRT2
      PARAMETER ( SQRT2 = 1.4142135623730950488D0 )
c
c ... Exe. statements ...
c
      IF ( N .EQ. 1 ) RETURN
c
      NRATIO = Nmax / N
      N2 = 2 * N
      NN = 1
      DO 10, K = 1, M-1
	 IS = 0
	 ID = N2
	 N2 = N2 / 2
	 N4 = N2 / 4
	 N8 = N4 / 2
 17      DO 15, I = IS, N-1, ID
	    I1 = I + 1
	    I2 = I1 + N4
	    I3 = I2 + N4
	    I4 = I3 + N4
	    T1 = X(I1) - X(I3)
	    X(I1) = X(I1) + X(I3)
	    X(I2) = 2 * X(I2)
	    X(I3) = T1 - 2 * X(I4)
	    X(I4) = T1 + 2 * X(I4)
	    IF ( N4 .EQ. 1 ) GOTO 15
	    I1 = I1 + N8
	    I2 = I2 + N8
	    I3 = I3 + N8
	    I4 = I4 + N8
	    T1 = ( X(I2) - X(I1) ) / SQRT2
	    T2 = ( X(I4) + X(I3) ) / SQRT2
	    X(I1) = X(I1) + X(I2)
	    X(I2) = X(I4) - X(I3)
	    X(I3) = 2 * ( - T2 - T1 )
	    X(I4) = 2 * ( - T2 + T1 )
 15      CONTINUE
	 IS = 2 * ID - N2
	 ID = 4 * ID
	 IF ( IS .LT. N-1 ) GOTO 17
	 IT = 0
	 ITS = NN * NRATIO
	 DO 20, J = 2, N8
	    IT = IT + ITS
	    IS = 0
	    ID = 2 * N2
 40         DO 30, I = IS, N-1, ID
	       I1 = I + J
	       I2 = I1 + N4
	       I3 = I2 + N4
	       I4 = I3 + N4
	       I5 = I + N4 - J + 2
	       I6 = I5 + N4
	       I7 = I6 + N4
	       I8 = I7 + N4
	       T1 = X(I1) - X(I6)
	       X(I1) = X(I1) + X(I6)
	       T2 = X(I5) - X(I2)
	       X(I5) = X(I2) + X(I5)
	       T3 = X(I8) + X(I3)
	       X(I6) = X(I8) - X(I3)
	       T4 = X(I4) + X(I7)
	       X(I2) = X(I4) - X(I7)
	       T5 = T1 - T4
	       T1 = T1 + T4
	       T4 = T2 - T3
	       T2 = T2 + T3
	       X(I3) = T4 * S1(IT) + T5 * C1(IT)
	       X(I7) = T5 * S1(IT) - T4 * C1(IT)
	       X(I4) = T1 * C3(IT) - T2 * S3(IT)
	       X(I8) = T2 * C3(IT) + T1 * S3(IT)
 30         CONTINUE
	    IS = 2 * ID - N2
	    ID = 4 * ID
	    IF ( IS .LT. N-1 ) GOTO 40
 20      CONTINUE
	 NN = 2 * NN
 10   CONTINUE
c
      IS = 1
      ID = 4
 70   DO 60, I0 = IS, N, ID
	 I1 = I0 + 1
	 R1 = X(I0)
	 X(I0) = R1 + X(I1)
	 X(I1) = R1 - X(I1)
 60   CONTINUE
      IS = 2 * ID - 1
      ID = 4 * ID
      IF ( IS .LT. N ) GOTO 70
c      
      CALL KSORENSENBITREV( X, N )
      DO 99, I = 1, N
	 X(I) = X(I) / N
 99   CONTINUE
      RETURN
c
c ... End of subroutine RFFTB ...
c
      END

