      SUBROUTINE MFFTOM(C,IMS,IVS,IES,NM,NV,NE,INDEX,ITEMP)
*
*   PURPOSE :
*     THIS ROUTINE PERFORMS A REORDERING OF A VECTOR-OF-2 VECTORS
*     OF COMPLEX C[IMS,NM [IVS,NV [IES,NE]]], ACCORDING TO A
*     PERMUTATION INDEX "INDEX".
*     SEE REF.[1] FOR NOTATIONS, AND COMMENTS TO MFFTDM ABOVE.
*  ARGUMENTS
*     C : VECTOR-OF-2 VECTORS TO BE REORDERED
*     IMS,IVS,IES,NM,NV,NE: THESE ARGUMENTS DESCRIBE THE STRUCTURE OF
*     C, ACCORDING TO THE ABOVE DEFINITION;
*     INDEX: INTEGER ARRAY , CONTAINING THE PERMUTATION INDEX  ;
*            IT IS NM ELEMENTS LONG ; PREPARED BY MFFTP.
*     IWORK: INTEGER ARRAY, OF LENGTH AT LEAST NM, USED AS WORKSPACE;
*
      INTEGER INDEX(0:*),ITEMP(0:*)
      COMPLEX C(0:IMS-1,0:*),T
 
      I3LIM=(NV-1)*IVS
      JLIM=(NE-1)*IES
      DO 1 I=0,NM-1
1     ITEMP(I)=INDEX(I)
 
      DO 4 I=1,NM-3
2       IF(ITEMP(I).NE.I)THEN
          IDEST=ITEMP(I)
          DO 3 I3=0,I3LIM,IVS
          DO 3 J=I3,I3+JLIM,IES
            T=C(J,I)
            C(J,I)=C(J,IDEST)
            C(J,IDEST)=T
3         CONTINUE
          ITEMP(I)=ITEMP(IDEST)
          ITEMP(IDEST)=IDEST
        GOTO 2
        ENDIF
4     CONTINUE
      END
