/* gpfa.f -- translated by f2c (version 19941113).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

typedef int integer;
#include <fftw.h>
typedef FFTW_REAL real;
typedef double doublereal;


/* Table of constant values */

static integer c__1 = 1;
static integer c__2 = 2;
static integer c__3 = 3;

/*        SUBROUTINE 'GPFA' */
/*        SELF-SORTING IN-PLACE GENERALIZED PRIME FACTOR (COMPLEX) FFT */

/*        *** THIS IS THE ALL-FORTRAN VERSION *** */
/*            ------------------------------- */

/*        CALL GPFA(A,B,TRIGS,INC,JUMP,N,LOT,ISIGN) */

/*        A IS FIRST REAL INPUT/OUTPUT VECTOR */
/*        B IS FIRST IMAGINARY INPUT/OUTPUT VECTOR */
/*        TRIGS IS A TABLE OF TWIDDLE FACTORS, PRECALCULATED */
/*              BY CALLING SUBROUTINE 'SETGPFA' */
/*        INC IS THE INCREMENT WITHIN EACH DATA VECTOR */
/*        JUMP IS THE INCREMENT BETWEEN DATA VECTORS */
/*        N IS THE LENGTH OF THE TRANSFORMS: */
/*          ----------------------------------- */
/*            N = (2**IP) * (3**IQ) * (5**IR) */
/*          ----------------------------------- */
/*        LOT IS THE NUMBER OF TRANSFORMS */
/*        ISIGN = +1 FOR FORWARD TRANSFORM */
/*              = -1 FOR INVERSE TRANSFORM */

/*        WRITTEN BY CLIVE TEMPERTON */
/*        RECHERCHE EN PREVISION NUMERIQUE */
/*        ATMOSPHERIC ENVIRONMENT SERVICE, CANADA */

/* ---------------------------------------------------------------------- */

/*        DEFINITION OF TRANSFORM */
/*        ----------------------- */

/*        X(J) = SUM(K=0,...,N-1)(C(K)*EXP(ISIGN*2*I*J*K*PI/N)) */

/* --------------------------------------------------------------------- */

/*        FOR A MATHEMATICAL DEVELOPMENT OF THE ALGORITHM USED, */
/*        SEE: */

/*        C TEMPERTON : "A GENERALIZED PRIME FACTOR FFT ALGORITHM */
/*          FOR ANY N = (2**P)(3**Q)(5**R)", */
/*          SIAM J. SCI. STAT. COMP., MAY 1992. */

/* ---------------------------------------------------------------------- */

/* Subroutine */ int gpfa(real *a, real *b, real *trigs, integer inc, 
	integer jump, integer n, integer lot, integer isign)
{
    integer pow_ii(integer *, integer *);

    /* Local variables */
    static integer ifac, i;
    extern /* Subroutine */ int gpfa2f(real *, real *, real *, integer *, 
	    integer *, integer *, integer *, integer *, integer *), gpfa3f(
	    real *, real *, real *, integer *, integer *, integer *, integer *
	    , integer *, integer *), gpfa5f(real *, real *, real *, integer *
	    , integer *, integer *, integer *, integer *, integer *);
    static integer kk, nj[3], ll, ip, iq, nn, ir;




/*     DECOMPOSE N INTO FACTORS 2,3,5 */
/*     ------------------------------ */
    /* Parameter adjustments */
    --trigs;
    --b;
    --a;

    /* Function Body */
    nn = n;
    ifac = 2;

    for (ll = 1; ll <= 3; ++ll) {
	kk = 0;
L10:
	if (nn % ifac != 0) {
	    goto L20;
	}
	++kk;
	nn /= ifac;
	goto L10;
L20:
	nj[ll - 1] = kk;
	ifac += ll;
/* L30: */
    }

    if (nn != 1) {
	return 1;
    }

    ip = nj[0];
    iq = nj[1];
    ir = nj[2];

/*     COMPUTE THE TRANSFORM */
/*     --------------------- */
    i = 1;
    if (ip > 0) {
	gpfa2f(&a[1], &b[1], &trigs[1], &inc, &jump, &n, &ip, &lot, &isign);
	i += pow_ii(&c__2, &ip) << 1;
    }
    if (iq > 0) {
	gpfa3f(&a[1], &b[1], &trigs[i], &inc, &jump, &n, &iq, &lot, &isign);
	i += pow_ii(&c__3, &iq) << 1;
    }
    if (ir > 0) {
	gpfa5f(&a[1], &b[1], &trigs[i], &inc, &jump, &n, &ir, &lot, &isign);
    }

    return 0;
} /* gpfa_ */

integer pow_ii(integer *ap, integer *bp)
{
	integer pow, x, n;

	x = *ap;
	n = *bp;

	if (n <= 0) {
		if (n == 0 || x == 1)
			return 1;
		if (x != -1)
			return x == 0 ? 1/x : 0;
		n = -n;
		}
	for(pow = 1; ; )
		{
		if(n & 01)
			pow *= x;
		if(n >>= 1)
			x *= x;
		else
			break;
		}
	return(pow);
}
