#ifndef __FXT_H
#define      __FXT_H

#ifndef __FXTAUX_H
#include <fftw.h>
#endif

/*  for pfafft() see pfafft.h ! */

/*  for modfft() (=ntt) see mod/mfft.h */

/*  general format of arguments: (FFTW_REAL *f, int ldn) */
/*  f := pointer to data array,  */
/*  ldn := base 2 log of array length */



/* ------- HARTLEY transforms -------------------------- */

/*  fht.cc: */
void fht(FFTW_REAL *f, int ldn);

/*  fht0.cc: */
void fht0(FFTW_REAL *f, int ldn);

/*  fhtdit2.cc: */
/* void dit2_fht(FFTW_REAL *f, int ldn); */

/*  fhtslow.cc: */
void slow_ht(FFTW_REAL *f, int n);


/* ------- FOURIER transforms -------------------------- */

/*  typical format of arguments: (FFTW_REAL *fr, FFTW_REAL *fi, int ldn, int is) */
/*  fr := pointer to data array (real part),  */
/*  fi := pointer to data array (imag part),  */
/*  ldn := base 2 log of array length */
/*  is := sign of exponent in fourier kernel */

/*  naming (semi-) conventions: */
/*  blabla_fft() := fft implementation with blabla-algorithm */
/*  blabla_fft0() := fft for zero paddad data  */
/*              (i.e. second half of the data is zero) */

/*  fftfht.cc: */
void fht_fft(FFTW_REAL *fr, FFTW_REAL *fi, int ldn, int is);
void fht_fft0(FFTW_REAL *fr, FFTW_REAL *fi, int ldn, int is);

/*  fourstep.cc: */
void four_step_fft(FFTW_REAL *fr, FFTW_REAL *fi, int ldn, int is);
void four_step_fft0(FFTW_REAL *fr, FFTW_REAL *fi, int ldn, int is);

/*  fftdif4.cc: */
void dif4_fft(FFTW_REAL *fr, FFTW_REAL *fi, int ldn, int is);

/*  fftdit4.cc: */
void dit4_fft(FFTW_REAL *fr, FFTW_REAL *fi, int ldn, int is);

/*  fftduh.cc: */
void duhamel_fft(FFTW_REAL *fr, FFTW_REAL *fi, int ldn, int is);

/* ------- REAL FOURIER --------------------- */

/*  info about the ordering of the data is in each source file */

/*  rfftfht.cc:  */
void fht_real_complex_fft(FFTW_REAL *f, int ldn);
void fht_real_complex_fft0(FFTW_REAL *f, int ldn);
void fht_complex_real_fft(FFTW_REAL *f, int ldn);

/*  rfftwrap.cc: */
void wrap_real_complex_fft(FFTW_REAL *f, int ldn);
void wrap_real_complex_fft0(FFTW_REAL *f, int ldn);
void wrap_complex_real_fft(FFTW_REAL *f, int ldn);

/*  rfftsplr.cc: */
void split_radix_real_complex_fft(FFTW_REAL *x, int ldn);
void split_radix_real_complex_fft0(FFTW_REAL *x, int ldn);

/*  rfftsplc.cc: */
void split_radix_complex_real_fft(FFTW_REAL *x, int ldn);


/* -------- REAL CONVOLUTION --------------------- */
/*  fhtcnvl.cc: */
void fht_convolution(FFTW_REAL *f, FFTW_REAL *g, int ldn);
void fht_convolution0(FFTW_REAL *f, FFTW_REAL *g, int ldn);

/*  fhtcnvla.cc: */
void fht_auto_convolution(FFTW_REAL *f, int ldn);  
void fht_auto_convolution0(FFTW_REAL *f, int ldn);  

/*  fhtcnvl2.cc: */
void fht_auto_convolution0_2proc(FFTW_REAL *f, int ldn);  

/*  fftcnvl.cc: */
void fht_fft_convolution(FFTW_REAL *f, FFTW_REAL *g, int ldn);
void wrap_fft_convolution(FFTW_REAL *f, FFTW_REAL *g, int ldn);
void split_radix_fft_convolution(FFTW_REAL *f, FFTW_REAL *g, int ldn);
void fht_fft_convolution0(FFTW_REAL *f, FFTW_REAL *g, int ldn);
void wrap_fft_convolution0(FFTW_REAL *f, FFTW_REAL *g, int ldn);
void split_radix_fft_convolution0(FFTW_REAL *f, FFTW_REAL *g, int ldn);

/*  fftcnvla.cc: */
void fht_fft_auto_convolution(FFTW_REAL *f, int ldn);
void wrap_fft_auto_convolution(FFTW_REAL *f, int ldn);
void split_radix_fft_auto_convolution(FFTW_REAL *f, int ldn);
void fht_fft_auto_convolution0(FFTW_REAL *f, int ldn);
void wrap_fft_auto_convolution0(FFTW_REAL *f, int ldn);
void split_radix_fft_auto_convolution0(FFTW_REAL *f, int ldn);

/*  slowcnvl.cc: */
void slow_auto_convolution(FFTW_REAL *f, int nu);
void slow_auto_convolution0(FFTW_REAL *f, int nu);
void slow_convolution(FFTW_REAL *w, FFTW_REAL *f, int nu);
void slow_convolution0(FFTW_REAL *w, FFTW_REAL *f, int nu);


/* -------- REAL CORRELATION --------------------- */
/*  fftcorr.cc: */
void fft_correlation(FFTW_REAL *f, FFTW_REAL *g, int ldn);
void fft_auto_correlation(FFTW_REAL *f, int ldn);

/*  slowcorr.cc: */
void slow_correlation(FFTW_REAL *w, FFTW_REAL *f, int nu);
void slow_correlation0(FFTW_REAL *w, FFTW_REAL *f, int nu);
void slow_auto_correlation(FFTW_REAL *f, int nu);
void slow_auto_correlation0(FFTW_REAL *f, int nu);


/* -------- COmplex COnvolution & COrrelation --------------------- */
/*  cococo.cc: */
void fft_complex_convolution(FFTW_REAL *f, FFTW_REAL *g, FFTW_REAL *r, FFTW_REAL *s, int ldn);
void fft_complex_auto_convolution(FFTW_REAL *f, FFTW_REAL *g, int ldn);
void fft_complex_correlation(FFTW_REAL *f, FFTW_REAL *g, FFTW_REAL *r, FFTW_REAL *s, int ldn);
void fft_complex_auto_correlation(FFTW_REAL *f, FFTW_REAL *g, int ldn);

/*  slowcoco.cc: */
void slow_complex_convolution(FFTW_REAL *wr, FFTW_REAL *wi, FFTW_REAL *fr, FFTW_REAL *fi, int n);
void slow_complex_auto_convolution(FFTW_REAL *fr, FFTW_REAL *fi, int n);
void slow_complex_correlation(FFTW_REAL *wr, FFTW_REAL *wi, FFTW_REAL *fr, FFTW_REAL *fi, int n);
void slow_complex_auto_correlation(FFTW_REAL *fr, FFTW_REAL *fi, int n);


/* -------- SPECTRUM ------------------------ */
/*  fhtspect.cc: */
void fht_spectrum(FFTW_REAL *f, int ldn);

/*  fftspect.cc: */
void fft_spectrum(FFTW_REAL *f, int ldn);


/*  ----- LEARNERS STRAIGHT & SIMPLE VERSIONS: ---- */
/*  even simpler (plain C) stuff is in simplfft/ */
/*  */
/*  fftdif2l.cc:  */
void dif2l_fft(FFTW_REAL *fr, FFTW_REAL *fi, int ldn, int is);
/*  */
/*  fftdit2l.cc: */
void dit2l_fft(FFTW_REAL *fr, FFTW_REAL *fi, int ldn, int is);
/*  */
/*  fftdif4l.cc: */
void dif4l_fft(FFTW_REAL *fr, FFTW_REAL *fi, int ldn, int is);
/*  */
/*  fftdit4l.cc: */
void dit4l_fft(FFTW_REAL *fr, FFTW_REAL *fi, int ldn, int is);



/* -------- OTHER FOURIER STUFF ------------------ */
/*  fftslow.cc: */
void slow_ft(FFTW_REAL *fr, FFTW_REAL *fi, int n, int is);

/*  fftchirp.cc: (arbitrary length fft) */
void chirp_fft(FFTW_REAL *fr, FFTW_REAL *fi, int n, int is);

/*  fftfract.cc: (fractional fft) */
void frft(FFTW_REAL *x, FFTW_REAL *y, int n, int is, FFTW_REAL v);

/*  fftndim.cc: (2...5 dim fft) */
void fft_ndim(FFTW_REAL *fr, FFTW_REAL *fi, int ndim, int *ldn, int is);


/* ---------- WRAPPERS FOR TYPE COMPLEX FOURIER ---------- */

#if 0
#include <complex.h>
#if defined __COMPLEXT__
#define Complex complex<FFTW_REAL>
#endif

/*  cfftwrap.cc: */
void complex_fft(Complex *c, int ldn, int is);
void real_imag_fft(FFTW_REAL *fr, FFTW_REAL *fi, int ldn, int is);
#endif

/* ---------- WALSH TRANSFORM ---------- */

/*  walshdif2.cc: */
void dif2_walsh_wak(FFTW_REAL *f, int ldn);
void dif2_walsh_pal(FFTW_REAL *f, int ldn);
void dif2_walsh_wal(FFTW_REAL *f, int ldn);

/*  walshdit2.cc: */
void dit2_walsh_wal(FFTW_REAL *f, int ldn);
void dit2_walsh_wal0(FFTW_REAL *f, int ldn);
void dit2_walsh_pal(FFTW_REAL *f, int ldn);
void dit2_walsh_pal0(FFTW_REAL *f, int ldn);
void dit2_walsh_wak(FFTW_REAL *f, int ldn);


/*  walshndim.cc: (2...5 dim walsh) */
void walsh_ndim(FFTW_REAL *f, int ndim, int *ldn);

/*  dyadiccnvl.cc: */
void dyadic_convolution(FFTW_REAL *f, FFTW_REAL *g, int ldn);
void dyadic_auto_convolution(FFTW_REAL *f, int ldn);
void dyadic_convolution0(FFTW_REAL *f, FFTW_REAL *g, int ldn);
void dyadic_auto_convolution0(FFTW_REAL *f, int ldn);


/* ------------------------------------------------- */


#if 0
/*  following moved to the 'bucket' directory: */

/*  cssnfht.cc: */
void fht_cosine_transform(FFTW_REAL *f, int ldn);
void fht_sine_transform(FFTW_REAL *f, int ldn);

/*  rspltfft.cc: */
void split_radix_real_complex_fft(FFTW_REAL *x, int ldn);

/*  fhttable.cc: */
void table_fht(FFTW_REAL *f, int ldn);

/*  fftdif4x.cc: (same as fftdif4.cc without the sumdiffs) */
void dif4x_fft(FFTW_REAL *fr, FFTW_REAL *fi, int ldn, int is);

/*  fftdit4x.cc: (same as fftdit4.cc without the sumdiffs) */
void dit4x_fft(FFTW_REAL *fr, FFTW_REAL *fi, int ldn, int is);

/*  fftdif2.cc: */
void dif2_fft(FFTW_REAL *fr, FFTW_REAL *fi, int ldn, int is);

/*  fftdit2.cc: */
void dit2_fft(FFTW_REAL *fr, FFTW_REAL *fi, int ldn, int is);

/*  fftdif4c.cc:  (uses type complex, optimized, but still slow) */
void dif4c_fft(FFTW_REAL *fr, FFTW_REAL *fi, int ldn, int is);

/*  fftdit4c.cc: (uses type complex, optimized, but still slow) */
void dit4c_fft(FFTW_REAL *fr, FFTW_REAL *fi, int ldn, int is);

/*  fftdif20.cc: */
void dif2_fft0(FFTW_REAL *fr, FFTW_REAL *fi, int ldn, int is);

#endif


#endif /*  !defined __FXT_H */
