#include <stdlib.h>
#include <math.h>

#include "fxt.h"
#include "fxtaux.h"
#include "aux4step.h"





void
mat_exp(FFTW_REAL *wr, FFTW_REAL *wi, int n1, int n2, int is)
/*  */
/*  multiply each element of n2 x n1 matrix  */
/*  by exp(is*2*PI*n1*n2/n) where n=n1*n2;   */
/*  */
{
    int n,k2;

    n=n1*n2;

    for(k2=0; k2<n2; ++k2)
    {
        row_exp(wr,wi,n,n1,k2,is);  

        wr+=n1;
        wi+=n1;
    }

    return;
}
/*  ================== end MAT_EXP =================== */

/* #define MAT_TRIG_REC */

void 
row_exp(FFTW_REAL *wr, FFTW_REAL *wi, int n, int n1, int k2, int is)
/*  */
/*  multiply array (length= n1) element k1 with exp(is*2.0*Pi*k1*k2/n) */
/*  */
{
    int k1;
    FFTW_REAL c,s;
#if defined MAT_TRIG_REC
    FFTW_REAL al,be;
#endif
    FFTW_REAL ph0;

    ph0=is*2.0*3.14159265358979323846264338327*k2/n;  
  
#if defined MAT_TRIG_REC

    al=sin(0.5*ph0);
    al*=2.0*al;
    be=sin(ph0);

    c=1.0;
    s=0.0; 
        
#endif

    for(k1=0; k1<n1; ++k1)
    {
        FFTW_REAL tr;

#if !defined MAT_TRIG_REC
	SINCOS(c,s,k1*ph0);
#endif

	tr     = c*wr[k1]-s*wi[k1];
	wi[k1] = s*wr[k1]+c*wi[k1];
	wr[k1] = tr;
 
#if defined MAT_TRIG_REC
	tr = c;
	c -= (al*tr+be*s);
	s -= (al*s-be*tr);
#endif
    }
}
/*  ================== end ROW_EXP =================== */


void 
mat_row_fft(FFTW_REAL *wr, FFTW_REAL *wi, int n1, int n2, int is, int zp)
/*  */
/*  n2 x n1 matrix (n2 rows of length n1) */
/*  */
{
    int k2,ldn1;

    ld(n1,ldn1);

    for(k2=0; k2<n2; ++k2)
    {
        if(zp!=0)  fht_fft0(wr,wi,ldn1,is);
        else       fht_fft(wr,wi,ldn1,is);

        wr+=n1;
        wi+=n1; 
    }
}
/*  ================== end MAT_ROW_FFT =================== */


void 
mat_col_fft(FFTW_REAL *wr, FFTW_REAL *wi, int n1, int n2, int is, int zp)
/*  */
/*  n2 x n1 matrix (n2 rows of length n1) */
/*  length of cols is n2 */
/*  */
{
    int k1,k2,ldn2,n2x;
    FFTW_REAL *cr,*ci,*p;

    cr=malloc(sizeof(FFTW_REAL)*(2*n2));
    /* assert(cr); */
    ci=cr+n2;

    ld(n2,ldn2);

    n2x=n2;
    if(zp!=0)  n2x/=2;    /*  avoid transfer of zeros */
 

    for(k1=0; k1<n1; ++k1)
    {

        for(k2=0,p=wr+k1; k2<n2x; ++k2,p+=n1)  /*  get real part */
        {
            cr[k2]=*p;
        }

        if(zp!=0)  /*  zero pad */
	{
            for(k2=n2x; k2<n2; ++k2)  cr[k2]=0.0;
	}

        for(k2=0,p=wi+k1; k2<n2x; ++k2,p+=n1)  /*  get imag part */
        {
            ci[k2]=*p;
        }

        if(zp!=0)  /*  zero pad */
	{
            for(k2=n2x; k2<n2; ++k2)  ci[k2]=0.0;
	}

        if(zp!=0)                             /*  transform  */
        {
            fht_fft0(cr,ci,ldn2,is);
        }
        else
        {
            fht_fft(cr,ci,ldn2,is);
        }


        for(k2=0,p=wr+k1; k2<n2; ++k2,p+=n1)  /*  put real part */
        {
            *p=cr[k2];
        }

        for(k2=0,p=wi+k1; k2<n2; ++k2,p+=n1)  /*  put imag part */
        {
            *p=ci[k2];
        }
    }

    free(cr);
}
/*  ================== end MAT_COL_FFT =================== */


void 
mat_col_fft_exp(FFTW_REAL *wr, FFTW_REAL *wi, int n1, int n2, int is, int zp)
/*  */
/*  n2 x n1 matrix (n2 rows of length n1) */
/*  length of cols is n2 */
/*  */
{
    int k1,k2,ldn2,n2x,n;
    FFTW_REAL *cr,*ci,*p;

    cr=malloc(sizeof(FFTW_REAL)*(2*n2));
    /* assert(cr); */
    ci=cr+n2;

    n=n1*n2;

    ld(n2,ldn2);

    n2x=n2;
    if(zp!=0)  n2x/=2;    /*  avoid transfer of zeros */
 

    for(k1=0; k1<n1; ++k1)
    {

        for(k2=0,p=wr+k1; k2<n2x; ++k2,p+=n1)  /*  get real part */
        {
            cr[k2]=*p;
        }

        if(zp!=0)  /*  zero pad */
	{
            for(k2=n2x; k2<n2; ++k2)  cr[k2]=0.0;
	}

        for(k2=0,p=wi+k1; k2<n2x; ++k2,p+=n1)  /*  get imag part */
        {
            ci[k2]=*p;
        }

        if(zp!=0)  /*  zero pad */
	{
            for(k2=n2x; k2<n2; ++k2)  ci[k2]=0.0;
	}

        if(zp!=0)  /*  transform  */
        {
            fht_fft0(cr,ci,ldn2,is);
        }
        else
        {
            fht_fft(cr,ci,ldn2,is);
        }


	/*  a 'row_exp_write(cr,ci,n,n2,k1,is,wr,wi)'-version  */
	/*  that interlaces the complex multiply with  */
	/*  the mem accesses (to wr and wi) may give speedup  */
        row_exp(cr,ci,n,n2,k1,is);


        for(k2=0,p=wr+k1; k2<n2; ++k2,p+=n1)  /*  put real part */
        {
            *p=cr[k2];
        }

        for(k2=0,p=wi+k1; k2<n2; ++k2,p+=n1)  /*  put imag part */
        {
            *p=ci[k2];
        }
    }

    free(cr);
}
/*  ================== end MAT_COL_FFT_EXP =================== */

#if 0

void 
mat_print(char *bla, FFTW_REAL *x, int rw, int cl)
{
    int i,j;

    cout<< bla;

    for(i=0;i<rw;++i)
    {
        cout<<"\n :";
        for(j=0; j<cl; ++j)
        {
            cout<<x[i*cl+j]<<", ";
        }
    }

    cout<<flush;
}
/*  ================== end MAT_PRINT =================== */



void 
mat2_print(char *bla, FFTW_REAL *fr, FFTW_REAL *fi, int rw, int cl)
{
    cout<< bla;

    mat_print("\n Re: ",fr,rw,cl);
    mat_print("\n Im: ",fi,rw,cl);
}
/*  ================== end MAT2_PRINT =================== */

#endif
