/* fftpack_cfftb.f -- translated by f2c (version 19941113).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

typedef int integer;
#include <fftw.h>
typedef FFTW_REAL real;

/*     SUBROUTINE FFTPACK_CFFTB(N,C,WSAVE) */

/*     SUBROUTINE FFTPACK_CFFTB COMPUTES THE BACKWARD COMPLEX DISCRETE FOURIER */
/*     TRANSFORM (THE FOURIER SYNTHESIS). EQUIVALENTLY , FFTPACK_CFFTB COMPUTES */
/*     A COMPLEX PERIODIC SEQUENCE FROM ITS FOURIER COEFFICIENTS. */
/*     THE TRANSFORM IS DEFINED BELOW AT OUTPUT PARAMETER C. */

/*     A CALL OF FFTPACK_CFFTF FOLLOWED BY A CALL OF FFTPACK_CFFTB WILL MULTIPLY THE */
/*     SEQUENCE BY N. */

/*     THE ARRAY WSAVE WHICH IS USED BY SUBROUTINE FFTPACK_CFFTB MUST BE */
/*     INITIALIZED BY CALLING SUBROUTINE FFTPACK_CFFTI(N,WSAVE). */

/*     INPUT PARAMETERS */


/*     N      THE LENGTH OF THE COMPLEX SEQUENCE C. THE METHOD IS */
/*            MORE EFFICIENT WHEN N IS THE PRODUCT OF SMALL PRIMES. */

/*     C      A COMPLEX ARRAY OF LENGTH N WHICH CONTAINS THE SEQUENCE */

/*     WSAVE   A REAL WORK ARRAY WHICH MUST BE DIMENSIONED AT LEAST 4N+15 */
/*             IN THE PROGRAM THAT CALLS FFTPACK_CFFTB. THE WSAVE ARRAY MUST BE */
/*             INITIALIZED BY CALLING SUBROUTINE FFTPACK_CFFTI(N,WSAVE) AND A */
/*             DIFFERENT WSAVE ARRAY MUST BE USED FOR EACH DIFFERENT */
/*             VALUE OF N. THIS INITIALIZATION DOES NOT HAVE TO BE */
/*             REPEATED SO LONG AS N REMAINS UNCHANGED THUS SUBSEQUENT */
/*             TRANSFORMS CAN BE OBTAINED FASTER THAN THE FIRST. */
/*             THE SAME WSAVE ARRAY CAN BE USED BY FFTPACK_CFFTF AND FFTPACK_CFFTB. */

/*     OUTPUT PARAMETERS */

/*     C      FOR J=1,...,N */

/*                C(J)=THE SUM FROM K=1,...,N OF */

/*                      C(K)*EXP(I*(J-1)*(K-1)*2*PI/N) */

/*                            WHERE I=SQRT(-1) */

/*     WSAVE   CONTAINS INITIALIZATION CALCULATIONS WHICH MUST NOT BE */
/*             DESTROYED BETWEEN CALLS OF SUBROUTINE FFTPACK_CFFTF OR FFTPACK_CFFTB */

/* Subroutine */ int fftpack_cfftb(integer n, real *c, real *wsave)
{
    extern /* Subroutine */ int fftpack_cfftb1(integer, real *, real *, real *, 
	    real *);
    static integer iw1, iw2;


    /* Parameter adjustments */
    --wsave;
    --c;

    /* Function Body */
    if (n == 1) {
	return 0;
    }
    iw1 = n + n + 1;
    iw2 = iw1 + n + n;
    fftpack_cfftb1(n, &c[1], &wsave[1], &wsave[iw1], &wsave[iw2]);
    return 0;
} /* fftpack_cfftb */

