/*
 * Copyright (c) 1997 Massachusetts Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to use, copy, modify, and distribute the Software without
 * restriction, provided the Software, including any modified copies made
 * under this license, is not distributed for a fee, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE MASSACHUSETTS INSTITUTE OF TECHNOLOGY BE LIABLE
 * FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of the Massachusetts
 * Institute of Technology shall not be used in advertising or otherwise
 * to promote the sale, use or other dealings in this Software without
 * prior written authorization from the Massachusetts Institute of
 * Technology.
 *
 */

#include "bench_utils.h"

typedef void essl_fft_proc(int *init, FFTW_COMPLEX *in, int *d1, int *d2,
                           FFTW_COMPLEX *out, int *d3, int *d4, int *n,
                           int *d5, int *isign, double *scale,
                           FFTW_REAL *aux1, int *naux1, FFTW_REAL *aux2, 
			   int *naux2);

essl_fft_proc dcft, scft;

void CCFFT(int *isign, int *n1, FFTW_REAL *scale,
	   FFTW_COMPLEX *x, FFTW_COMPLEX *y,
	   FFTW_REAL *table, FFTW_REAL *work,
	   int *isys);

void cilk_many_fft_init(int n, FFTW_COMPLEX *temp_space, int factors[40]);
void cilk_fft_aux(int n, FFTW_COMPLEX * in, FFTW_COMPLEX * out, int *factors,
		  FFTW_COMPLEX * W, int nW);

int npfa(int nmin);
int npfao(int nmin, int nmax);
void pfacc(int isign, int n, FFTW_COMPLEX *z);

int rft(FFTW_COMPLEX * in, unsigned n, FFTW_COMPLEX * out);
int fft(FFTW_COMPLEX * in, unsigned n, FFTW_COMPLEX * out);

int fft_in_C(FFTW_COMPLEX x[], int length);
int ifft_in_C(FFTW_COMPLEX x[], int length);

void mixfft(int n, FFTW_REAL xRe[], FFTW_REAL xIm[], FFTW_REAL yRe[], FFTW_REAL yIm[]);

int go_fft(FFTW_REAL *a, FFTW_REAL *b, int ntot, int n, int nspan, int isn);

void FORTRANIZE(singletonfft,SINGLETONFFT)(FFTW_REAL *a, FFTW_REAL *b, int *ntot, int *n, int *nspan, 
	      int *isn);

int fftpack_cffti(int n, FFTW_COMPLEX * wsave);
int fftpack_cfftf(int n, FFTW_COMPLEX * c, FFTW_COMPLEX * wsave);
int fftpack_cfftb(int n, FFTW_COMPLEX * c, FFTW_COMPLEX * wsave);

void nrc_four1(FFTW_REAL data[], unsigned int nn, int isign);
void FORTRANIZE(nrffour1,NRFFOUR1)(FFTW_COMPLEX data[], int *nn, int *isign);

int setgpfa(FFTW_COMPLEX *trigs, int n);
int gpfa(FFTW_REAL *a, FFTW_REAL *b, FFTW_COMPLEX *trigs, int inc,
         int jump, int n, int lot, int isign);

void FORTRANIZE(gpfafsetgpfa,GPFAFSETGPFA)(FFTW_COMPLEX *trigs, int *n);
void FORTRANIZE(gpfafgpfa,GPFAFGPFA)
(FFTW_REAL *a, FFTW_REAL *b, FFTW_COMPLEX *trigs, int *inc,
 int *jump, int *n, int *lot, int *isign);

int napack_fft(FFTW_COMPLEX *a, int *n, FFTW_COMPLEX *w);

void  mayer_fft_1(int n, FFTW_REAL *real, FFTW_REAL *imag);
void mayer_ifft_1(int n, FFTW_REAL *real, FFTW_REAL *imag);
void  mayer_fft_5(int n, FFTW_REAL *real, FFTW_REAL *imag);
void mayer_ifft_5(int n, FFTW_REAL *real, FFTW_REAL *imag);
void  mayer_fft_7(int n, FFTW_REAL *real, FFTW_REAL *imag);
void mayer_ifft_7(int n, FFTW_REAL *real, FFTW_REAL *imag);

int fft_duhamel(FFTW_REAL *x, FFTW_REAL *y, int np);
void BeauregardFFT(FFTW_COMPLEX *X, int LogN, int Direction);

int green_fftInit(int M);
void green_fftFree(void);
void green_ffts(FFTW_COMPLEX *ioptr, int M, int Rows);
void green_iffts(FFTW_COMPLEX *ioptr, int M, int Rows);
int green_fft3dInit(int Mx, int My, int Mz);
void green_fft3dFree(void);
void green_fft3d(FFTW_COMPLEX *ioptr, int Mx, int My, int Mz);
void green_ifft3d(FFTW_COMPLEX *ioptr, int Mx, int My, int Mz);

void FORTRANIZE(dcffti,DCCFFTI)(int *n, FFTW_COMPLEX * wsave);
void FORTRANIZE(dcfftf,DCCFFTF)(int *n, FFTW_COMPLEX * c, 
				FFTW_COMPLEX * wsave);
void FORTRANIZE(dcfftb,DCCFFTB)(int *n, FFTW_COMPLEX * c, 
				FFTW_COMPLEX * wsave);

void FORTRANIZE(scffti,SCCFFTI)(int *n, FFTW_COMPLEX * wsave);
void FORTRANIZE(scfftf,SCCFFTF)(int *n, FFTW_COMPLEX * c, 
				FFTW_COMPLEX * wsave);
void FORTRANIZE(scfftb,SCCFFTB)(int *n, FFTW_COMPLEX * c, 
				FFTW_COMPLEX * wsave);

/* Bailey FFT: */
void FORTRANIZE(mpinix,MPINIX)(int *m, FFTW_REAL *u);
void FORTRANIZE(mpcfft,MPCFFT)(int *IS, int *M, FFTW_COMPLEX *X, 
			       FFTW_COMPLEX *Y, FFTW_REAL *U);

void FORTRANIZE(brennerfft,BRENNERFFT)(FFTW_COMPLEX *x, int *n, int *rank, 
					 int *isign, 
					 int *iform, FFTW_COMPLEX *work);

void ooura_c_cdft(int n, int isgn, FFTW_COMPLEX *a, int *ip, FFTW_COMPLEX *w);
void FORTRANIZE(oourafcdft,OOURAFCDFT)(int *n, int *isgn, 
					   FFTW_COMPLEX *a, int *ip,
					   FFTW_COMPLEX *w);

#define __FXTAUX_H /* hack so that fxt.h doesn't #include <fftw.h> */
#ifdef macintosh /* Mac compilers don't use pathnames */
#include "fxt.h"
#else
#include "c_source/fxt/fxt.h"
#endif

short bergland_fft1d(FFTW_COMPLEX *, int);

void tablesixstepfft(FFTW_COMPLEX *, int, int);

void FORTRANIZE(cfftsr,CFFTSR)(FFTW_REAL *, FFTW_REAL *, int *, int*);
void FORTRANIZE(icfftsr,ICFFTSR)(FFTW_REAL *, FFTW_REAL *, int *, int*);
void FORTRANIZE(tinit,TINIT)(int *,
			     FFTW_REAL*,FFTW_REAL*,FFTW_REAL*,FFTW_REAL*,
			     int *);
void FORTRANIZE(ctfftsr,CTFFTSR)(FFTW_REAL *, FFTW_REAL *, int *,
				 FFTW_REAL*,FFTW_REAL*,FFTW_REAL*,FFTW_REAL*,
				 int *);

void FORTRANIZE(burruscfft,BURRUSCFFT)(FFTW_REAL*,FFTW_REAL*,
					 int*,int*,int*);
void FORTRANIZE(sfftfu,SFFTFU)(FFTW_REAL*,FFTW_REAL*,
					 int*,int*,int*);

void FORTRANIZE(monrofastf,MONROFASTF)(FFTW_REAL*,FFTW_REAL*,int *);

#ifdef macintosh /* Mac compilers don't use pathnames */
#include "gsl_fft_complex.h"
#else
#include "c_source/gsl/gsl_fft_complex.h"
#endif

void    cfqft(FFTW_REAL *R, FFTW_REAL *I, FFTW_REAL *x, FFTW_REAL *y, 
	      int n, int k);
int     qftinit(int n, void *work);

void FORTRANIZE(emayerfft,EMAYERFFT)(FFTW_COMPLEX *arr,int *n);
void FORTRANIZE(emayerifft,EMAYERIFFT)(FFTW_COMPLEX *arr,int *n);

int ouvre_fft(int, FFTW_REAL);
int ferme_fft(void);
int monnier_fft(FFTW_COMPLEX *);

void Bloodworth_Q2_FwdFFT(FFTW_COMPLEX *, int);
void Bloodworth_Q2_RevFFT(FFTW_COMPLEX *, int);
