#include "config_unix.h"
#include "config_win32.h"

#include "rtp.h"

/* $Id: beacon.h,v 1.4 2004/02/18 03:15:47 jdugan Exp $ */

#if 0
typedef struct {
    uint32_t ssrc; /* Receiver SSRC */
    uint32_t fract_lost; /* already divided by 2.56 */
    uint32_t total_lost;
    uint32_t lsr;
    uint32_t dlsr;
    uint32_t last_seq;
    uint32_t jitter;
} recv_rept;
#endif

typedef struct bevent {
    rtp_event_type type;
    uint32_t       ssrc; /* Sender SSRC */
    uint32_t       time; /* time of event, in suitable units */
    rtcp_rr        *rr; /* if this event is an rr, this will non NULL */
    struct bevent  *next; /* next event in queue */
} beacon_event;

rtp_t beacon_init(const char *addr, uint16_t rx_port, uint16_t tx_port,
                  int ttl, double rtcp_bw, uint8_t *userdata);
rtp_t beacon_init_if(const char *addr, char *iface, uint16_t rx_port, 
                     uint16_t tx_port, int ttl, double rtcp_bw, 
                     uint8_t *userdata);
void beacon_callback( struct rtp *session, rtp_event *event );
beacon_event *beacon_get_next_event(void);
beacon_event *process_event( rtp_event *event );
void beacon_free_event(beacon_event *be);
int beacon_queue_len(void);
