#include <GL/glut.h>

#include "viewer.h"

#include "contours.h"

static Contours *contours;

static void display_contours()
{
  glClearColor(1.0, 1.0, 1.0, 0.0);
  glClear(GL_COLOR_BUFFER_BIT);

    draw_contours(contours);

    glFlush();
}

void main(int argc, char **argv)
{
    int size;
    String contours_file;
    Line title, error_msg;

    printf(product);

    glutInit(&argc, argv);

    if (help_request(argc, argv, help_table))
	exit (0);

    if ((argc != 2) && (argc != 3))
    {
        sprintf(error_msg, "correct usage: %s <contours file> [<size>]",
								argv[0]);
        ERROR_AND_EXIT(error_msg);
    }

    if (argc == 3)
    {
	contours_file = argv[1];
	size = atoi(argv[2]);
    }
    else
    {
	contours_file = argv[1];
	size = 500;
    }

    glutInitWindowSize(size, size);
    sprintf(title, "contours: %s", contours_file);
    glutCreateWindow(title);
    glutDisplayFunc(display_contours);

    if ((contours = load_contours(contours_file, error_msg)) == NULL)
        ERROR_AND_EXIT(error_msg);

    glutMainLoop();
}
