#ifndef _incl_types
#define _incl_types

#include "macros.h"

#ifdef Status
#undef Status
#endif

#ifdef Bool
#undef Bool
#endif

#ifndef _incl_widget
typedef char  *String;
#endif

typedef enum { OK, ERROR, OTHER } Status;
typedef enum { NEITHER, YES, NO, CANCEL } YesNo;

typedef void Generic;
typedef Generic *Generic_ptr;
typedef int Bool;
typedef char Line[LINE_SIZE+1];
typedef char Long_line[LONG_LINE_SIZE+1];
typedef char Param_value[LINE_SIZE+1];

typedef void (*Transform)(float *, float *);

typedef int (*Compare_func)(Generic_ptr, Generic_ptr);
typedef Bool (*Equal_func)(Generic_ptr, Generic_ptr);
typedef Status (*Check_func)(Generic_ptr);
typedef void (*Data_func)(Generic_ptr);
typedef Bool (*Truth_func)(Generic_ptr);
typedef int (*Search_func)(int);

typedef YesNo (*YesNo_func)(String msg, String yes, String no, String cancel);

typedef struct
{
    Status (*start_print)(String error_msg);
    void (*print_message)(String message);
    void (*end_print)();
}   Print_funcs;

typedef struct
{
    void (*start_timer)(String message);
    int (*update_timer)(float fraction);
    void (*stop_timer)(Status status);
}   Timer_funcs;

#define  SCREEN_DISPLAY		0
#define  PAPER_DISPLAY		1

typedef struct
{
    int display_medium;
    Generic_ptr data;
    void (*start_draw)(Generic_ptr data);
    void (*end_draw)();
    void (*new_draw_range)(float x0, float y0, float x1, float y1, Bool clip);
    void (*draw_line)(float x0, float y0, float x1, float y1);
    void (*draw_text)(String text, float x, float y, float a, float b);
    void (*set_draw_color)(int color);
    void (*set_draw_font)(String name, int size);
    void (*set_line_style)(int line_style);
}   Draw_funcs;

#endif /* _incl_types */
