#include "macros.h"
#include "types.h"

#define  HEADER_SIZE  4096

/* swap_bytes assumes that there are 4 bytes per word */

void swap_bytes(char *ptr, int nbytes)
{
    char *ptr2;

    for (ptr2 = ptr+nbytes; ptr < ptr2; ptr += 4)
    {
	SWAP(ptr[0], ptr[3], char);
	SWAP(ptr[1], ptr[2], char);
    }
}

void main(int argc, char **argv)
{
    int i, ndim, n = HEADER_SIZE, x[HEADER_SIZE];
    float *y = (float *) x;
    Line error_msg, par_file;
    char *file_in;
    FILE *fp;
    Bool swap;

    if (argc < 2)
    {
	sprintf(error_msg, "correct syntax: %s <matrix file> [<swap>]", argv[0]);
	ERROR_AND_EXIT(error_msg);
    }

    file_in = argv[1];

    if (argc > 2)
    {
	swap = TRUE;
	printf("assuming bytes swapped in matrix file\n");
    }
    else
    {
	swap = FALSE;
	printf("assuming bytes not swapped in matrix file\n");
    }

    if ((fp = fopen(file_in, READ)) == NULL)
	ERROR_AND_EXIT("opening matrix file");

    if (fread((void *) x, BYTES_PER_WORD, n, fp) != n)
	ERROR_AND_EXIT("reading matrix file header");

    fclose(fp);

    if (swap)
	swap_bytes((void *) x, BYTES_PER_WORD*n);

    sprintf(par_file, "%s.par", file_in);

    if ((fp = fopen(par_file, WRITE)) == NULL)
	ERROR_AND_EXIT("opening par file");

    fprintf(fp, "! %s\n", par_file);
    fprintf(fp, "\n");

    ndim = x[0];

    printf("number of dimensions = %d\n", ndim);

    fprintf(fp, "ndim %d\n", ndim);
    fprintf(fp, "file %s\n", file_in);
    fprintf(fp, "head %d\n", n);

    if (swap)
	fprintf(fp, "swap\n");

    for (i = 0; i < ndim; i++)
    {
	fprintf(fp, "\n");
	fprintf(fp, "dim %d\n", i+1);
	fprintf(fp, "npts %d\n", x[20+1*ndim+i]);
	fprintf(fp, "block %d\n", x[20+4*ndim+i]);
	fprintf(fp, "sw %3.2f\n", y[20+7*ndim+i]);
	fprintf(fp, "sf %3.2f\n", y[20+6*ndim+i]);
	fprintf(fp, "refppm %3.2f\n", y[20+8*ndim+i]);
	fprintf(fp, "refpt %3.2f\n", y[20+9*ndim+i]);
    }

    fclose(fp);
}
