#include "save.h"

#include "par.h"
#include "utility.h"

static Status write_data_file(FILE *fp, float *data, int row_size, int *npoints,
				int *first, int *block_size, String error_msg)
{
    int ind, i0, i1, n0, n1, p0, p1;
    float z = 0;
    int nblocks[DISPLAY_DIM];

/* zero padding is not very efficient, 1 word at a time, should not matter */

    BLOCKS(nblocks, npoints, block_size, DISPLAY_DIM);

    for (n1 = 0; n1 < nblocks[1]; n1++)
    {
	if (n1 < nblocks[1] - 1)
	    p1 = block_size[1];
	else
	    p1 = 1 + (npoints[1] - 1) % block_size[1];

	for (n0 = 0; n0 < nblocks[0]; n0++)
	{
	    if (n0 < nblocks[0] - 1)
		p0 = block_size[0];
	    else
		p0 = 1 + (npoints[0] - 1) % block_size[0];

	    ind = first[0] + n0*block_size[0];
	    ind += row_size * (first[1] + n1*block_size[1]);

	    for (i1 = 0; i1 < p1; i1++)
	    {
/*
		if (FWRITE(data + ind, BYTES_PER_WORD, p0, fp))
*/
		if (endian_fwrite((char *) (data + ind), p0, fp) == ERROR)
		{
		    sprintf(error_msg, "writing block (%d, %d), row %d",
								n0, n1, i1);
		    return  ERROR;
		}

		for (i0 = 0; i0 < block_size[0]-p0; i0++)
		{
/*
		    if (FWRITE(&z, BYTES_PER_WORD, 1, fp))
*/
		    if (endian_fwrite((char *) &z, 1, fp) == ERROR)
		    {
			sprintf(error_msg,
				"writing block (%d, %d), row %d, zero %d",
							n0, n1, i1, i0);
			return  ERROR;
		    }
		}

		ind += row_size;
	    }

	    for (i1 = 0; i1 < block_size[1]-p1; i1++)
	    {
		for (i0 = 0; i0 < block_size[0]; i0++)
		{
/*
		    if (FWRITE(&z, BYTES_PER_WORD, 1, fp))
*/
		    if (endian_fwrite((char *) &z, 1, fp) == ERROR)
		    {
			sprintf(error_msg,
				"writing block (%d, %d), row %d, zero %d",
							n0, n1, i1, i0);
			return  ERROR;
		    }
		}
	    }
	}
    }

    return  OK;
}

Status save_data_set(String data_file, String param_file,
	Data_info *data_info, int *first, int *last, String error_msg)
{
    int i, size_of_block = 4096, npoints[DISPLAY_DIM], block_size[DISPLAY_DIM];
    FILE *fp;
    Ref_info ref[DISPLAY_DIM];
    Par_info par_info;
    Status status;

    for (i = 0; i < DISPLAY_DIM; i++)
    {
	find_sub_ref(ref+i, data_info->ref+i, first[i], last[i], 1,
						data_info->npoints[i]);
	npoints[i] = last[i] - first[i];
    }
    
    find_block_sizes(DISPLAY_DIM, size_of_block, npoints, block_size, FALSE);

    CHECK_OPEN_FOR_BINARY_WRITING(fp, data_file);

    status = write_data_file(fp, data_info->data, data_info->npoints[0],
				npoints, first, block_size, error_msg);

    fclose(fp);

    CHECK_STATUS(status);

    par_info.file = data_file;
    par_info.ndim = DISPLAY_DIM;
    par_info.npoints = npoints;
    par_info.block_size = block_size;
    par_info.ref = ref;
    par_info.swapped = FALSE;
    par_info.integer = FALSE;
    par_info.blocked = TRUE;
    par_info.header = 0;
    par_info.deflated = FALSE;
    par_info.level = 0;

    CHECK_STATUS(write_par_file(param_file, &par_info, error_msg));

    return  OK;
}
