#include "rowcol_popup.h"

#include "rowcol.hlp"

#include "baseline_popup.h"
#include "callback.h"
#include "data.h"
#include "info_popup.h"
#include "param.h"
#include "phase_popup.h"
#include "rowcol.h"
#include "rowcol_func.h"
#include "slice_popup.h"
#include "window.h"

#define  VISIBLE_ITEMS  5

static Widget rowcol_popup = (Widget) NULL;
static Widget rowcol_form;
static Widget rowcol_list = (Widget) NULL;

static Widget point_field;

static Textfield_item point_items[] =
{
    { "point range: ", point_range, NO_CALLBACK, NO_DATA, &point_field }
};

static int npoint_texts = ARRAY_SIZE(point_items);

static Widget reference_boxes[NREF_TYPES];
static Radiobox_item reference_items[NREF_TYPES];

static int ref_type = REF_POINTS;
static int nref_types = ARRAY_SIZE(reference_boxes);

#define  NON_OFF_TYPES  2

static Widget point_ruler_boxes[NON_OFF_TYPES];
static Radiobox_item point_ruler_items[] =
{
    { "visible", NO_CALLBACK, NO_DATA, point_ruler_boxes + VISIBILITY_ON },
    { "invisible", NO_CALLBACK, NO_DATA, point_ruler_boxes + VISIBILITY_OFF }
};

static int point_ruler_type = VISIBILITY_ON;
static int npoint_ruler_types = ARRAY_SIZE(point_ruler_boxes);

static Widget point_axis_boxes[NON_OFF_TYPES];
static Radiobox_item point_axis_items[] =
{
    { "visible", NO_CALLBACK, NO_DATA, point_axis_boxes + VISIBILITY_ON },
    { "invisible", NO_CALLBACK, NO_DATA, point_axis_boxes + VISIBILITY_OFF }
};

static int point_axis_type = VISIBILITY_ON;
static int npoint_axis_types = ARRAY_SIZE(point_axis_boxes);

static Widget value_field;

static Textfield_item value_items[] =
{
    { "value range: ", value_range, NO_CALLBACK, NO_DATA, &value_field }
};

static int nvalue_texts = ARRAY_SIZE(value_items);

static Widget value_ruler_boxes[NON_OFF_TYPES];
static Radiobox_item value_ruler_items[] =
{
    { "visible", NO_CALLBACK, NO_DATA, value_ruler_boxes + VISIBILITY_ON },
    { "invisible", NO_CALLBACK, NO_DATA, value_ruler_boxes + VISIBILITY_OFF }
};

static int value_ruler_type = VISIBILITY_ON;
static int nvalue_ruler_types = ARRAY_SIZE(value_ruler_boxes);

static Widget value_axis_boxes[NON_OFF_TYPES];
static Radiobox_item value_axis_items[] =
{
    { "visible", NO_CALLBACK, NO_DATA, value_axis_boxes + VISIBILITY_ON },
    { "invisible", NO_CALLBACK, NO_DATA, value_axis_boxes + VISIBILITY_OFF }
};

static int value_axis_type = VISIBILITY_ON;
static int nvalue_axis_types = ARRAY_SIZE(value_axis_boxes);

#define  NROW_COL_TYPES  2

static Widget row_col_boxes[NROW_COL_TYPES];
static Radiobox_item row_col_items[] =
{
    { "row", NO_CALLBACK, NO_DATA, row_col_boxes + ROW_SLICE },
    { "column", NO_CALLBACK, NO_DATA, row_col_boxes + COLUMN_SLICE }
};

static int row_col_type = ROW_SLICE;
static int nrow_col_types = ARRAY_SIZE(row_col_boxes);

#define NNEW_ADD_TYPES  2

static Widget new_add_boxes[NNEW_ADD_TYPES];
static Radiobox_item new_add_items[] =
{
    { "new", NO_CALLBACK, NO_DATA, new_add_boxes + NEW_SLICE },
    { "add", NO_CALLBACK, NO_DATA, new_add_boxes + ADD_SLICE }
};

static int new_add_type = NEW_SLICE;
static int nnew_add_types = ARRAY_SIZE(new_add_boxes);

static Widget rows_cols_field;

static Textfield_item textfield_items[] =
{
    { "rows/columns: ", rows_cols, NO_CALLBACK, NO_DATA, &rows_cols_field }
};

static int ntexts = ARRAY_SIZE(textfield_items);

static int nrowcol_sets = 0;

/*
static Bool have_valid_rowcol = FALSE;
*/

static void set_rowcol_fields()
{
    set_textfields(point_items, npoint_texts);
    set_textfields(value_items, nvalue_texts);
    set_textfields(textfield_items, ntexts);
}

void update_rowcol_params()
{
    if (rowcol_popup)
    {
	get_textfields(point_items, npoint_texts);
	get_textfields(value_items, nvalue_texts);
	get_textfields(textfield_items, ntexts);

	ref_type = get_radio_state(reference_boxes, nref_types);
    	point_ruler_type = get_radio_state(point_ruler_boxes,
						npoint_ruler_types);
    	point_axis_type = get_radio_state(point_axis_boxes,
						npoint_axis_types);
    	value_ruler_type = get_radio_state(value_ruler_boxes,
						nvalue_ruler_types);
    	value_axis_type = get_radio_state(value_axis_boxes,
						nvalue_axis_types);
    	row_col_type = get_radio_state(row_col_boxes, nrow_col_types);
    	new_add_type = get_radio_state(new_add_boxes, nnew_add_types);

	sprintf(rowcol_ref, "%d", ref_type);
	sprintf(point_ruler, "%d", point_ruler_type);
	sprintf(point_axis, "%d", point_axis_type);
	sprintf(value_ruler, "%d", value_ruler_type);
	sprintf(value_axis, "%d", value_axis_type);
	sprintf(row_col, "%d", row_col_type);
	sprintf(new_add, "%d", new_add_type);
    }
    else
    {
	if (*rowcol_ref)
	    ref_type = atoi(rowcol_ref);

	if (*point_ruler)
	    point_ruler_type = atoi(point_ruler);

	if (*point_axis)
	    point_axis_type = atoi(point_axis);

	if (*value_ruler)
	    value_ruler_type = atoi(value_ruler);

	if (*value_axis)
	    value_axis_type = atoi(value_axis);

	if (*row_col)
	{
	    row_col_type = atoi(row_col);

	    if (row_col_type != COLUMN_SLICE)  /* protection against abuse */
		row_col_type = ROW_SLICE;
	}

	if (*new_add)
	{
	    new_add_type = atoi(new_add);

	    if (new_add_type != ADD_SLICE)  /* protection against abuse */
		new_add_type = NEW_SLICE;
	}
    }
}

void remove_rowcol_set(int rowcol_set)
{
    remove_rowcol_set_func(rowcol_set);

    if (rowcol_set < nrowcol_sets)
    {
	if (rowcol_list)
	    delete_from_list(rowcol_list, rowcol_set+1);

	nrowcol_sets--;
    }
}

void register_rowcol_set(int rowcol_set, String name)
{
    if (rowcol_set >= nrowcol_sets)
    {
	if (rowcol_list)
	    insert_in_list(rowcol_list, name, 0);

	nrowcol_sets++;
    }

    register_rowcol_set_func(rowcol_set);
}

Status rowcol_apply(Slice_info *slice_info, Data_info *data_info,
							String error_msg)
{
    update_rowcol_params();
/*
    have_valid_rowcol = FALSE;
*/
    CHECK_STATUS(rowcol_apply_func(slice_info, data_info, error_msg));
/*
    have_valid_rowcol = TRUE;
*/

    return  OK;
}

void change_point_rowcol(int size, int begin, int end, int type)
{
    Line error_msg;

    (void) change_point_rowcol_func(size, begin, end, type, error_msg);

    if (rowcol_popup)
	set_textfields(point_items, npoint_texts);
}

void change_value_rowcol(float multiplier)
{
    Line error_msg;

    (void) change_value_rowcol_func(multiplier, error_msg);

    if (rowcol_popup)
	set_textfields(value_items, nvalue_texts);
}

static void cycle_set(int rowcol_set)
{
    if (rowcol_set == -1)
	return;

    select_from_list(rowcol_list, rowcol_set+1, FALSE);

    do_slice_drawing(TRUE);
}

static void cycle_point()
{
    int n;

    if (sscanf(rows_cols, "%d", &n) != 1)
	return;

    if (rowcol_popup)
	set_textfields(textfield_items, ntexts);

    do_slice_drawing(TRUE);
}

static void select_command(int rowcol_set)
{
    rowcol_select_func(rowcol_set);
}

static void select_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    int rowcol_set = list_position(cbs);

    select_command(rowcol_set);
}

Status rowcol_select_command(String value, Generic_ptr data, String error_msg)
{
    int rowcol_set;

    if (!data_name_exists(value, &rowcol_set))
    {
	sprintf(error_msg, "data name '%s' unknown", value);
	return  ERROR;
    }

    select_command(rowcol_set);

    return  OK;
}

static void next_set_command()
{
    int rowcol_set;

    rowcol_next_set_func(&rowcol_set);
    cycle_set(rowcol_set);
}

static void next_set_callback(Widget widget, Callback_ptr data,
							Callback_ptr cbs)
{
    next_set_command();
}

Status rowcol_next_set_command(String value, Generic_ptr data, String error_msg)
{
    next_set_command();

    return  OK;
}

static void previous_set_command()
{
    int rowcol_set;

    rowcol_previous_set_func(&rowcol_set);
    cycle_set(rowcol_set);
}

static void previous_set_callback(Widget widget, Callback_ptr data,
							Callback_ptr cbs)
{
    previous_set_command();
}

Status rowcol_previous_set_command(String value, Generic_ptr data,
							String error_msg)
{
    previous_set_command();

    return  OK;
}

static void next_point_command()
{
    rowcol_next_point_func();
    cycle_point();
}

static void next_point_callback(Widget widget, Callback_ptr data,
							Callback_ptr cbs)
{
    next_point_command();
}

Status rowcol_next_point_command(String value, Generic_ptr data,
							String error_msg)
{
    next_point_command();

    return  OK;
}

static void previous_point_command()
{
    rowcol_previous_point_func();
    cycle_point();
}

static void previous_point_callback(Widget widget, Callback_ptr data,
							Callback_ptr cbs)
{
    previous_point_command();
}

Status rowcol_previous_point_command(String value, Generic_ptr data,
							String error_msg)
{
    previous_point_command();

    return  OK;
}

static Status apply_command(String error_msg)
{
    do_slice_drawing(TRUE);

    return  OK;
}

static void apply_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    Line error_msg;

    if (apply_command(error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);
}

Status rowcol_apply_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(apply_command(error_msg));

    return  OK;
}

static Status stats_command(String error_msg)
{
    static Print_funcs print_funcs = { start_info, print_info, end_info };

    CHECK_STATUS(rowcol_stats_func(&print_funcs, slice_limits, error_msg));

    return  OK;
}

static void stats_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    Line error_msg;

    update_rowcol_params();

    if (stats_command(error_msg) == ERROR)
        ERROR_AND_RETURN(error_msg);
}

Status rowcol_stats_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(stats_command(error_msg));

    return  OK;
}

static void phase_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    phase_popup_callback(get_topshell(), data, cbs);
}

static void baseline_callback(Widget widget, Callback_ptr data,
							Callback_ptr cbs)
{
    baseline_popup_callback(get_topshell(), data, cbs);
}

static String rowcol_string_func(int n, Generic_ptr data)
{
    return  get_data_name(n);
}

static Widget create_rowcol_list_form(Widget parent)
{
    Scrolled_list_info rowcol_list_info;
    Widget label, buttons, form;
    static Button_item button_items[] =
    {
	{ "next",	next_set_callback,		NO_DATA },
	{ "previous",	previous_set_callback,		NO_DATA }
    };
    static int nbuttons = ARRAY_SIZE(button_items);

    form = create_form(parent);
    CHECK_WIDGET(form);

    label = create_label(form, "data sets:");
    CHECK_WIDGET_DESTROY(label, form);
    attachments(label, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    buttons = create_vertical_buttons(form, button_items, nbuttons);
    CHECK_WIDGET_DESTROY(buttons, form);
    attachments(buttons, label, NO_ATTACH, FORM_ATTACH, NO_ATTACH);
    offsets(buttons, 2*UNIT_OFFSET, NO_OFFSET, 2*UNIT_OFFSET, NO_OFFSET);

    rowcol_list_info.selection_policy = SINGLE_SELECT;
    rowcol_list_info.nitems = nrowcol_sets;
    rowcol_list_info.func = rowcol_string_func;
    rowcol_list_info.nvisible_items = VISIBLE_ITEMS;
    rowcol_list_info.callback = select_callback;

    rowcol_list = create_scrolled_list(form, &rowcol_list_info);
    CHECK_WIDGET_DESTROY(rowcol_list, form);
    attachments(WIDGET_PARENT(rowcol_list),
			label, FORM_ATTACH, buttons, FORM_ATTACH);
    offsets(WIDGET_PARENT(rowcol_list),
			UNIT_OFFSET, UNIT_OFFSET, 2*UNIT_OFFSET, UNIT_OFFSET);

    manage_widget(form);

    return  form;
}

static void create_rowcol_popup(Widget parent)
{
    Widget form, form2, radio, buttons, texts, separator, buttons2, radio2;
    static Button_item button_items1[] =
    {
    	{ "next",	next_point_callback,		NO_DATA },
    	{ "previous",	previous_point_callback,	NO_DATA }
    };
    static int nbuttons1 = ARRAY_SIZE(button_items1);
    static Button_item button_items2[] =
    {
    	{ "stats",	stats_callback,			NO_DATA },
    	{ "phasing",	phase_callback,			NO_DATA },
    	{ "baseline",	baseline_callback,		NO_DATA }
    };
    static int nbuttons2 = ARRAY_SIZE(button_items2);
    Apply_dismiss_help_info adh_info;
    char apply_label[] = "apply";

    update_rowcol_params();

    rowcol_popup = create_popup(parent, "Select Slice");
    CHECK_WIDGET_WARNING(rowcol_popup);

    rowcol_form = create_form(rowcol_popup);
    CHECK_WIDGET_DESTROY_WARNING(rowcol_form, rowcol_popup);

    form = create_rowcol_list_form(rowcol_form);
    CHECK_WIDGET_DESTROY_WARNING(form, rowcol_popup);
    attachments(form, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    separator = create_separator(rowcol_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, rowcol_popup);
    attachments(separator, form, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    texts = create_textfields(rowcol_form, point_items, npoint_texts);
    CHECK_WIDGET_DESTROY_WARNING(texts, rowcol_popup);
    attachments(texts, separator, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    set_reference_items((Box_item *) reference_items, reference_boxes);
    radio = create_radiobox(rowcol_form, reference_items,
                                        nref_types, ref_type, HORIZONTAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, rowcol_popup);
    attachments(radio, texts, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    form = create_label_radiobox(rowcol_form, "point ruler: ",
		point_ruler_items, npoint_ruler_types, point_ruler_type);
    CHECK_WIDGET_DESTROY_WARNING(form, rowcol_popup);
    attachments(form, radio, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    form2 = create_label_radiobox(rowcol_form, "point axis: ",
		point_axis_items, npoint_axis_types, point_axis_type);
    CHECK_WIDGET_DESTROY_WARNING(form2, rowcol_popup);
    attachments(form2, form, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    separator = create_separator(rowcol_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, rowcol_popup);
    attachments(separator, form2, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    texts = create_textfields(rowcol_form, value_items, nvalue_texts);
    CHECK_WIDGET_DESTROY_WARNING(texts, rowcol_popup);
    attachments(texts, separator, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    form = create_label_radiobox(rowcol_form, "value ruler: ",
		value_ruler_items, nvalue_ruler_types, value_ruler_type);
    CHECK_WIDGET_DESTROY_WARNING(form, rowcol_popup);
    attachments(form, texts, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    form2 = create_label_radiobox(rowcol_form, "value axis: ",
		value_axis_items, nvalue_axis_types, value_axis_type);
    CHECK_WIDGET_DESTROY_WARNING(form2, rowcol_popup);
    attachments(form2, form, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    separator = create_separator(rowcol_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, rowcol_popup);
    attachments(separator, form2, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    radio = create_radiobox(rowcol_form, row_col_items, nrow_col_types,
						row_col_type, HORIZONTAL);
    CHECK_WIDGET_DESTROY_WARNING(radio, rowcol_popup);
    attachments(radio, separator, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    buttons = create_horizontal_buttons(rowcol_form, button_items1, nbuttons1);
    CHECK_WIDGET_DESTROY_WARNING(buttons, rowcol_popup);
    attachments(buttons, separator, NO_ATTACH, NO_ATTACH, FORM_ATTACH);
    offsets(buttons, UNIT_OFFSET, UNIT_OFFSET, NO_OFFSET, NO_OFFSET);

    radio2 = create_radiobox(rowcol_form, new_add_items, nnew_add_types,
						new_add_type, HORIZONTAL);
    CHECK_WIDGET_DESTROY_WARNING(radio2, rowcol_popup);
    attachments(radio2, radio, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    texts = create_textfields(rowcol_form, textfield_items, ntexts);
    CHECK_WIDGET_DESTROY_WARNING(texts, rowcol_popup);
    attachments(texts, radio2, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    separator = create_separator(rowcol_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, rowcol_popup);
    attachments(separator, texts, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    buttons = create_horizontal_buttons(rowcol_form, button_items2, nbuttons2);
    CHECK_WIDGET_DESTROY_WARNING(buttons, rowcol_popup);
    attachments(buttons, separator, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(buttons, UNIT_OFFSET, UNIT_OFFSET, NO_OFFSET, NO_OFFSET);

    adh_info.apply_label = apply_label;
    adh_info.apply_callback = apply_callback;
    adh_info.dismiss_form = rowcol_form;
    adh_info.help_message = rowcol_help;

    buttons2 = create_apply_dismiss_help(rowcol_form, &adh_info);
    CHECK_WIDGET_DESTROY_WARNING(buttons2, rowcol_popup);
    attachments(buttons2, buttons, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(buttons2, UNIT_OFFSET, UNIT_OFFSET, NO_OFFSET, NO_OFFSET);

    set_rowcol_fields();

    manage_widget(rowcol_form);
}

void rowcol_popup_callback(Widget parent, Callback_ptr data, Callback_ptr cbs)
{
    if (!rowcol_popup)
	create_rowcol_popup(parent);

    if (rowcol_popup)
	popup(rowcol_form);
}

Status rowcol_popup_command(String value, Generic_ptr data, String error_msg)
{
    rowcol_popup_callback(get_topshell(), (Callback_ptr) NULL,
							(Callback_ptr) NULL);

    return  OK;
}
