#include "output.h"

#include "date.h"
#include "utility.h"

#define  MIN_SIZE_PTS  6

Status get_output_param(Output_param *param, String error_msg)
{
    int i;

    if (get_floats(PLOT_DIM, param->size, param->size_string) == ERROR)
    {
	sprintf(error_msg, "size must be array of size %d", PLOT_DIM);
        return  ERROR;
    }

    for (i = 0; i < PLOT_DIM; i++)
    {
	if (param->size[i] < 0)
    	{
	    sprintf(error_msg, "size #%d is %2.1e, must be >= 0",
							i+1, param->size[i]);
            return  ERROR;
    	}
    }

    return  OK;
}

float *get_paper_size(int size)
{
    return  paper_sizes[size];
}

static Status find_other_size(String other_size, float scale, String error_msg)
{
    int i;
    float *size = paper_sizes[OTHER_SIZE];

    if (get_floats(PLOT_DIM, size, other_size) == ERROR)
	RETURN_ERROR_MSG("cannot read 'Other' paper size");

    SCALE_VECTOR(size, size, scale, PLOT_DIM);

    for (i = 0; i < PLOT_DIM; i++)
    {
	if (size[i] < 10*MIN_SIZE_PTS)
	{
	    sprintf(error_msg,
		"'Other' paper size #%d is %2.0f (pts), must be >= %d",
					i+1, size[i], 10*MIN_SIZE_PTS);
	    return  ERROR;
	}
    }

    return  OK;
}

Status setup_output(Output_setup *setup, String error_msg)
{
    int i, type;
    float scale;
    Output_choices *choices;
    float p_size[PLOT_DIM];

    choices = setup->choices;

    if (setup->size_units == INCH_UNITS)
	scale = PTS_PER_IN;
    else
	scale = PTS_PER_CM;

    type = choices->paper_size;

    if (type == OTHER_SIZE)
	CHECK_STATUS(find_other_size(choices->other_size, scale, error_msg));

    if (choices->paper_dirn == PORTRAIT)
    {
	p_size[0] = paper_sizes[type][0];
	p_size[1] = paper_sizes[type][1];
    }
    else /* choices->paper == LANDSCAPE */
    {
	p_size[0] = paper_sizes[type][1];
	p_size[1] = paper_sizes[type][0];
    }

    if (setup->size_mode == SIZE_PICTURE)
    {
	for (i = 0; i < PLOT_DIM; i++)
	    choices->plot_size[i] = scale * choices->plot_size[i];
    }
    else
    {
	for (i = 0; i < PLOT_DIM; i++)
	    choices->plot_size[i] = p_size[i] - 2*scale*choices->plot_size[i];
    }

    for (i = 0; i < PLOT_DIM; i++)
    {
	if (choices->plot_size[i] < MIN_SIZE_PTS)
	{
	    sprintf(error_msg,
			"output size #%d is %5.2f (pts), must be >= %d",
				i+1, choices->plot_size[i], MIN_SIZE_PTS);
	    return  ERROR;
	}
	else if (choices->plot_size[i] > p_size[i])
	{
	    sprintf(error_msg,
			"output size #%d is %2.0f (pts), must be <= %2.0f",
				i+1, choices->plot_size[i], p_size[i]);
	    return  ERROR;
	}
    }

/*  done already in output_save_func() in output_func.c
    get_time_and_date(choices->time_date->text);
*/

    return  OK;
}

void setup_border(Output_border *border, String text, String font_name,
			int font_size, int justification, int edge, Bool use)
{
    border->text = text;
    border->font_name = font_name;
    border->font_size = font_size;
    border->justification = justification;
    border->edge = edge;
    border->use = use;
}

float convert_to_printer_points(float p, int units)
{
    if (units == INCH_UNITS)
	return  (p * PTS_PER_IN);
    else /* (units == CM_UNITS) */
	return  (p * PTS_PER_CM);
}
