#include "fold_popup.h"

#include "fold.hlp"

#include "callback.h"
#include "display_popup.h"
#include "info_popup.h"
#include "param.h"
#include "fold.h"
#include "fold_func.h"
#include "region_popup.h"
#include "window.h"

static Widget fold_popup = (Widget) NULL;
static Widget fold_form;

#define  NFOLD_BOXES  3

static Widget x_fold_boxes[NFOLD_BOXES];
static Radiobox_item x_fold_items[] =
{
    { "none", NO_CALLBACK, NO_DATA, x_fold_boxes + REGION_NO_FOLD },
    { "wrap", NO_CALLBACK, NO_DATA, x_fold_boxes + REGION_WRAP },
    { "reflect", NO_CALLBACK, NO_DATA, x_fold_boxes + REGION_REFLECT }
};

static int x_fold_type = REGION_NO_FOLD;
static int nx_fold_types = ARRAY_SIZE(x_fold_boxes);

static Widget y_fold_boxes[NFOLD_BOXES];
static Radiobox_item y_fold_items[] =
{
    { "none", NO_CALLBACK, NO_DATA, y_fold_boxes + REGION_NO_FOLD },
    { "wrap", NO_CALLBACK, NO_DATA, y_fold_boxes + REGION_WRAP },
    { "reflect", NO_CALLBACK, NO_DATA, y_fold_boxes + REGION_REFLECT }
};

static int y_fold_type = REGION_NO_FOLD;
static int ny_fold_types = ARRAY_SIZE(y_fold_boxes);

#define  NFLIP_BOXES  2

static Widget x_flip_boxes[NFLIP_BOXES];
static Radiobox_item x_flip_items[] =
{
    { "off", NO_CALLBACK, NO_DATA, x_flip_boxes + PEAK_FLIP_OFF },
    { "on", NO_CALLBACK, NO_DATA, x_flip_boxes + PEAK_FLIP_ON }
};

static int x_flip_type = PEAK_FLIP_OFF;
static int nx_flip_types = ARRAY_SIZE(x_flip_boxes);

static Widget y_flip_boxes[NFLIP_BOXES];
static Radiobox_item y_flip_items[] =
{
    { "off", NO_CALLBACK, NO_DATA, y_flip_boxes + PEAK_FLIP_OFF },
    { "on", NO_CALLBACK, NO_DATA, y_flip_boxes + PEAK_FLIP_ON }
};

static int y_flip_type = PEAK_FLIP_OFF;
static int ny_flip_types = ARRAY_SIZE(y_flip_boxes);

static Widget x_width_min_field, x_width_max_field;
static Widget x_center_min_field, x_center_max_field;
static Widget y_width_min_field, y_width_max_field;
static Widget y_center_min_field, y_center_max_field;

static Textfield_item x_width_items[] =
{
    { (char *) NULL, x_width_min, NO_CALLBACK, NO_DATA, &x_width_min_field },
    { (char *) NULL, x_width_max, NO_CALLBACK, NO_DATA, &x_width_max_field }
};

static Textfield_item x_center_items[] =
{
    { (char *) NULL, x_center_min, NO_CALLBACK, NO_DATA, &x_center_min_field },
    { (char *) NULL, x_center_max, NO_CALLBACK, NO_DATA, &x_center_max_field }
};

static Textfield_item y_width_items[] =
{
    { (char *) NULL, y_width_min, NO_CALLBACK, NO_DATA, &y_width_min_field },
    { (char *) NULL, y_width_max, NO_CALLBACK, NO_DATA, &y_width_max_field }
};

static Textfield_item y_center_items[] =
{
    { (char *) NULL, y_center_min, NO_CALLBACK, NO_DATA, &y_center_min_field },
    { (char *) NULL, y_center_max, NO_CALLBACK, NO_DATA, &y_center_max_field }
};

static int nlimits = 2;

static Scale_numbers x_width_numbers;
static Scale_numbers x_center_numbers;
static Scale_numbers y_width_numbers;
static Scale_numbers y_center_numbers;

static Widget x_width_scale = (Widget) NULL;
static Widget x_center_scale = (Widget) NULL;
static Widget y_width_scale = (Widget) NULL;
static Widget y_center_scale = (Widget) NULL;

static Bool x_width_scale_active = FALSE;
static Bool x_center_scale_active = FALSE;
static Bool y_width_scale_active = FALSE;
static Bool y_center_scale_active = FALSE;

#define  VALUE_IN_RANGE(numbers) \
	 {   if ((numbers.value < numbers.minimum) || \
		 (numbers.value > numbers.maximum)) \
		 numbers.value = 0.5*(numbers.minimum + numbers.maximum);   }

#define  SET_VALUE(string, value) \
	 {   sprintf(string, "%7.2f", value);   }

static void set_numbers(Scale_numbers *numbers, String min, String max,
								String value)
{
    numbers->minimum = atof(min);
    numbers->maximum = atof(max);
    numbers->value = atof(value);
}

static void set_fold_numbers()
{
    set_numbers(&x_width_numbers, x_width_min, x_width_max, x_width_value);
    set_numbers(&x_center_numbers, x_center_min, x_center_max, x_center_value);
    set_numbers(&y_width_numbers, y_width_min, y_width_max, y_width_value);
    set_numbers(&y_center_numbers, y_center_min, y_center_max, y_center_value);
}

static void set_fold_fields()
{
    if (fold_popup)
    {
        set_textfields(x_width_items, nlimits);
        set_textfields(x_center_items, nlimits);
        set_textfields(y_width_items, nlimits);
        set_textfields(y_center_items, nlimits);
    }
}

static void get_fold_values()
{
    SET_VALUE(x_width_value, x_width_numbers.value);
    SET_VALUE(x_center_value, x_center_numbers.value);
    SET_VALUE(y_width_value, y_width_numbers.value);
    SET_VALUE(y_center_value, y_center_numbers.value);
}

void update_fold_params()
{
    if (fold_popup)
    {
	x_fold_type = get_radio_state(x_fold_boxes, nx_fold_types);
	y_fold_type = get_radio_state(y_fold_boxes, ny_fold_types);
	x_flip_type = get_radio_state(x_flip_boxes, nx_flip_types);
	y_flip_type = get_radio_state(y_flip_boxes, ny_flip_types);

	get_textfields(x_width_items, nlimits);
	get_textfields(x_center_items, nlimits);
	get_textfields(y_width_items, nlimits);
	get_textfields(y_center_items, nlimits);

	sprintf(x_fold, "%d", x_fold_type);
	sprintf(y_fold, "%d", y_fold_type);
	sprintf(x_flip, "%d", x_flip_type);
	sprintf(y_flip, "%d", y_flip_type);
    }
    else
    {
	if (*x_fold)
	    x_fold_type = atoi(x_fold);

	if (*y_fold)
	    y_fold_type = atoi(y_fold);

	if (*x_flip)
	    x_flip_type = atoi(x_flip);

	if (*y_flip)
	    y_flip_type = atoi(y_flip);

	set_fold_params();
    }

    set_fold_numbers();
}

static Status check_min_max(Scale_numbers *numbers, String msg,
							String error_msg)
{
    if (numbers->minimum >= numbers->maximum)
    {
	sprintf(error_msg, "%s: minimum >= maximum", msg);
	return  ERROR;
    }

    return  OK;
}

static void set_fold_scales()
{
    set_fold_numbers();

    if (x_width_scale)
	set_scale_numbers(x_width_scale, &x_width_numbers);

    if (x_center_scale)
	set_scale_numbers(x_center_scale, &x_center_numbers);

    if (y_width_scale)
	set_scale_numbers(y_width_scale, &y_width_numbers);

    if (y_center_scale)
	set_scale_numbers(y_center_scale, &y_center_numbers);
}

static Status valid_fold_numbers(String error_msg)
{
    CHECK_STATUS(check_min_max(&x_width_numbers, "x_width", error_msg));
    CHECK_STATUS(check_min_max(&x_center_numbers, "x_center", error_msg));
    CHECK_STATUS(check_min_max(&y_width_numbers, "y_width", error_msg));
    CHECK_STATUS(check_min_max(&y_center_numbers, "y_center", error_msg));

    VALUE_IN_RANGE(x_width_numbers);
    VALUE_IN_RANGE(x_center_numbers);
    VALUE_IN_RANGE(y_width_numbers);
    VALUE_IN_RANGE(y_center_numbers);

    get_fold_values();
    set_fold_scales();

    return  OK;
}

void set_center_width(float *lower, float *upper)
{
    set_fold_range(lower, upper);

    set_fold_fields();
    set_fold_scales();
}

static void scale_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    float lower[DISPLAY_DIM], upper[DISPLAY_DIM];

    if (widget == x_width_scale)
    {
	if (!x_width_scale_active)
	{
	    x_width_scale_active = TRUE;
	    x_center_scale_active = FALSE;
	    y_width_scale_active = FALSE;
	    y_center_scale_active = FALSE;

	    set_scale_numbers(x_width_scale, &x_width_numbers);

	    return;
	}

	get_scale_value(cbs, &x_width_numbers);
    }
    else if (widget == x_center_scale)
    {
	if (!x_center_scale_active)
	{
	    x_width_scale_active = FALSE;
	    x_center_scale_active = TRUE;
	    y_width_scale_active = FALSE;
	    y_center_scale_active = FALSE;

	    set_scale_numbers(x_center_scale, &x_center_numbers);

	    return;
	}

	get_scale_value(cbs, &x_center_numbers);
    }
    else if (widget == y_width_scale)
    {
	if (!y_width_scale_active)
	{
	    x_width_scale_active = FALSE;
	    x_center_scale_active = FALSE;
	    y_width_scale_active = TRUE;
	    y_center_scale_active = FALSE;

	    set_scale_numbers(y_width_scale, &y_width_numbers);

	    return;
	}

	get_scale_value(cbs, &y_width_numbers);
    }
    else if (widget == y_center_scale)
    {
	if (!y_center_scale_active)
	{
	    x_width_scale_active = FALSE;
	    x_center_scale_active = FALSE;
	    y_width_scale_active = FALSE;
	    y_center_scale_active = TRUE;

	    set_scale_numbers(y_center_scale, &y_center_numbers);

	    return;
	}

        get_scale_value(cbs, &y_center_numbers);
    }
    else
    {
	ERROR_AND_RETURN("should not be here in scale_callback");
    }

    get_fold_values();

    get_fold_range(lower, upper);

    set_new_region(lower, upper);

    do_display_drawing();
}

static Status apply_command(String error_msg)
{
    update_fold_params();
    set_fold_fields();

    CHECK_STATUS(valid_fold_numbers(error_msg));

    do_display_drawing();

    return  OK;
}

static void apply_callback(Widget widget, Callback_ptr data, Callback_ptr cbs)
{
    Line error_msg;

    if (apply_command(error_msg) == ERROR)
	ERROR_AND_RETURN(error_msg);
}

Status fold_apply_command(String value, Generic_ptr data, String error_msg)
{
    CHECK_STATUS(apply_command(error_msg));

    return  OK;
}

static void create_fold_popup(Widget parent)
{
    Widget buttons, label, form, form2, separator, scale1, scale2;
    static Line fold_label = "    folding: ";
    static Line flip_label = "peak flip: ";
    Apply_dismiss_help_info adh_info;
    char apply_label[] = "apply";
    static Scale_info x_width_scale_info =
	{ HORIZONTAL, &x_width_numbers, TRUE, "width",
				scale_callback, scale_callback, NO_DATA };
    static Scale_info x_center_scale_info =
	{ HORIZONTAL, &x_center_numbers, TRUE, "center",
				scale_callback, scale_callback, NO_DATA };
    static Scale_info y_width_scale_info =
	{ HORIZONTAL, &y_width_numbers, TRUE, "width",
				scale_callback, scale_callback, NO_DATA };
    static Scale_info y_center_scale_info =
	{ HORIZONTAL, &y_center_numbers, TRUE, "center",
				scale_callback, scale_callback, NO_DATA };
    static Text_scale_info x_width_info =
		{ &x_width_scale_info, &x_width_scale, x_width_items };
    static Text_scale_info x_center_info =
		{ &x_center_scale_info, &x_center_scale, x_center_items };
    static Text_scale_info y_width_info =
		{ &y_width_scale_info, &y_width_scale, y_width_items };
    static Text_scale_info y_center_info =
		{ &y_center_scale_info, &y_center_scale, y_center_items };
    Line error_msg;

    update_fold_params();

    if (valid_fold_numbers(error_msg) == ERROR)
    {
	default_fold_numbers();
	set_fold_numbers();
    }

    fold_popup = create_popup(parent, "Folding Region");
    CHECK_WIDGET_WARNING(fold_popup);

    fold_form = create_form(fold_popup);
    CHECK_WIDGET_DESTROY_WARNING(fold_form, fold_popup);

    label = create_label(fold_form, "x direction:");
    CHECK_WIDGET_DESTROY_WARNING(label, fold_popup);
    attachments(label, FORM_ATTACH, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    form = create_label_radiobox(fold_form, fold_label,
				x_fold_items, nx_fold_types, x_fold_type);
    CHECK_WIDGET_DESTROY_WARNING(form, fold_popup);
    attachments(form, label, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    form2 = create_label_radiobox(fold_form, flip_label,
				x_flip_items, nx_flip_types, x_flip_type);
    CHECK_WIDGET_DESTROY_WARNING(form2, fold_popup);
    attachments(form2, form, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    scale1 = create_text_scale(fold_form, &x_width_info);
    CHECK_WIDGET_DESTROY_WARNING(scale1, fold_popup);
    attachments(scale1, form2, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    scale2 = create_text_scale(fold_form, &x_center_info);
    CHECK_WIDGET_DESTROY_WARNING(scale2, fold_popup);
    attachments(scale2, scale1, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    separator = create_separator(fold_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, fold_popup);
    attachments(separator, scale2, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    label = create_label(fold_form, "y direction:");
    CHECK_WIDGET_DESTROY_WARNING(label, fold_popup);
    attachments(label, separator, NO_ATTACH, FORM_ATTACH, NO_ATTACH);

    form = create_label_radiobox(fold_form, fold_label,
				y_fold_items, ny_fold_types, y_fold_type);
    CHECK_WIDGET_DESTROY_WARNING(form, fold_popup);
    attachments(form, label, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    form2 = create_label_radiobox(fold_form, flip_label,
				y_flip_items, ny_flip_types, y_flip_type);
    CHECK_WIDGET_DESTROY_WARNING(form2, fold_popup);
    attachments(form2, form, NO_ATTACH, NO_ATTACH, FORM_ATTACH);

    scale1 = create_text_scale(fold_form, &y_width_info);
    CHECK_WIDGET_DESTROY_WARNING(scale1, fold_popup);
    attachments(scale1, form2, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    scale2 = create_text_scale(fold_form, &y_center_info);
    CHECK_WIDGET_DESTROY_WARNING(scale2, fold_popup);
    attachments(scale2, scale1, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    separator = create_separator(fold_form);
    CHECK_WIDGET_DESTROY_WARNING(separator, fold_popup);
    attachments(separator, scale2, NO_ATTACH, FORM_ATTACH, FORM_ATTACH);

    adh_info.apply_label = apply_label;
    adh_info.apply_callback = apply_callback;
    adh_info.dismiss_form = fold_form;
    adh_info.help_message = fold_help;

    buttons = create_apply_dismiss_help(fold_form, &adh_info);
    CHECK_WIDGET_DESTROY_WARNING(buttons, fold_popup);
    attachments(buttons, separator, FORM_ATTACH, FORM_ATTACH, FORM_ATTACH);
    offsets(buttons, UNIT_OFFSET, UNIT_OFFSET, NO_OFFSET, NO_OFFSET);

    manage_widget(fold_form);
}

void fold_popup_callback(Widget parent, Callback_ptr data, Callback_ptr cbs)
{
    if (!fold_popup)
        create_fold_popup(parent);

    if (fold_popup)
    {
	x_width_scale_active = FALSE;
	x_center_scale_active = FALSE;
	y_width_scale_active = FALSE;
	y_center_scale_active = FALSE;

	popup(fold_form);
    }
}

Status fold_popup_command(String value, Generic_ptr data, String error_msg)
{
    fold_popup_callback(get_topshell(), (Callback_ptr) NULL,
							(Callback_ptr) NULL);

    return  OK;
}
